/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.sensor;

import java.io.Serializable;
import org.apache.commons.io.FilenameUtils;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.foundation.OpenEdgeMetrics;

public class OpenEdgeSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(OpenEdgeSensor.class);

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("oe").name(this.getClass().getSimpleName());
    }

    public void execute(SensorContext context) {
        if (context.runtime().getProduct() == SonarProduct.SONARLINT) {
            return;
        }
        this.computeBaseMetrics(context);
    }

    private void computeBaseMetrics(SensorContext context) {
        FilePredicates predicates = context.fileSystem().predicates();
        for (InputFile file : context.fileSystem().inputFiles(predicates.and(predicates.hasLanguage("oe"), predicates.hasType(InputFile.Type.MAIN)))) {
            LOG.trace("Computing basic metrics on {}", (Object)file);
            String fileExt = FilenameUtils.getExtension((String)file.filename());
            if ("w".equalsIgnoreCase(fileExt)) {
                context.newMeasure().on((InputComponent)file).withValue((Serializable)Integer.valueOf(1)).forMetric(OpenEdgeMetrics.WINDOWS).save();
                continue;
            }
            if ("p".equalsIgnoreCase(fileExt)) {
                context.newMeasure().on((InputComponent)file).withValue((Serializable)Integer.valueOf(1)).forMetric(OpenEdgeMetrics.PROCEDURES).save();
                continue;
            }
            if ("i".equalsIgnoreCase(fileExt)) {
                context.newMeasure().on((InputComponent)file).withValue((Serializable)Integer.valueOf(1)).forMetric(OpenEdgeMetrics.INCLUDES).save();
                continue;
            }
            if (!"cls".equalsIgnoreCase(fileExt)) continue;
            context.newMeasure().on((InputComponent)file).withValue((Serializable)Integer.valueOf(1)).forMetric(OpenEdgeMetrics.CLASSES).save();
        }
    }
}

