/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.sensor;

import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.foundation.InputFileUtils;
import org.sonar.plugins.openedge.foundation.OpenEdgeRulesDefinition;
import org.sonar.plugins.openedge.foundation.OpenEdgeSettings;

public class OpenEdgeWarningsSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(OpenEdgeWarningsSensor.class);
    private final OpenEdgeSettings settings;

    public OpenEdgeWarningsSensor(OpenEdgeSettings settings) {
        this.settings = settings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("oe").name(this.getClass().getSimpleName());
    }

    public void execute(SensorContext context) {
        if (context.runtime().getProduct() == SonarProduct.SONARLINT) {
            return;
        }
        this.settings.init();
        int warningsImportNum = 0;
        RuleKey defaultWarningRuleKey = RuleKey.of((String)"rssw-oe", (String)"compiler.warning");
        if (context.activeRules().find(defaultWarningRuleKey) == null) {
            LOG.info("'Compiler warning' rule is not activated in your profile - Warning files analysis skipped");
            return;
        }
        FilePredicates predicates = context.fileSystem().predicates();
        for (InputFile file : context.fileSystem().inputFiles(predicates.and(predicates.hasLanguage("oe"), predicates.hasType(InputFile.Type.MAIN)))) {
            LOG.debug("Looking for warnings of {}", (Object)file);
            this.processFile(context, file);
            ++warningsImportNum;
            if (!context.isCancelled()) continue;
            LOG.info("Analysis cancelled...");
            return;
        }
        LOG.info("{} warning files imported", (Object)warningsImportNum);
    }

    private void processFile(SensorContext context, InputFile file) {
        File listingFile = this.settings.getWarningsFile(file);
        if (listingFile != null && listingFile.exists()) {
            LOG.debug("Import warnings for {}", (Object)file);
            try {
                WarningsProcessor processor = new WarningsProcessor();
                Files.asCharSource((File)listingFile, (Charset)StandardCharsets.UTF_8).readLines((LineProcessor)processor);
                Iterator iterator = processor.getResult().iterator();
                while (iterator.hasNext()) {
                    Warning w = (Warning)iterator.next();
                    RuleKey ruleKey = RuleKey.of((String)"rssw-oe", (String)("compiler.warning." + w.msgNum));
                    boolean isManagedByCABL = OpenEdgeRulesDefinition.isWarningManagedByCABL(w.msgNum);
                    if (context.activeRules().find(ruleKey) == null) {
                        if (isManagedByCABL) continue;
                        ruleKey = RuleKey.of((String)"rssw-oe", (String)"compiler.warning");
                        w.msg = w.msg + " (" + w.msgNum + ")";
                    }
                    FilePredicate fp1 = context.fileSystem().predicates().hasRelativePath(w.file);
                    FilePredicate fp2 = context.fileSystem().predicates().hasAbsolutePath(context.fileSystem().baseDir().toPath().resolve(w.file).normalize().toString());
                    InputFile target = context.fileSystem().inputFile(fp1);
                    if (target == null) {
                        target = context.fileSystem().inputFile(fp2);
                    }
                    if (target != null) {
                        LOG.debug("Warning File {} - Line {} - Message {}", new Object[]{target, w.line, w.msg});
                        NewIssue issue = context.newIssue().forRule(ruleKey);
                        NewIssueLocation location = issue.newLocation().on((InputComponent)target);
                        if (w.line > 0) {
                            location.at(target.selectLine(w.line));
                        }
                        if (target == file) {
                            location.message(w.msg);
                        } else {
                            location.message("From " + InputFileUtils.getRelativePath(file, context.fileSystem()) + " - " + w.msg);
                        }
                        issue.at(location).save();
                        continue;
                    }
                    LOG.info("Found warning on non-existing file {}", (Object)w.file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class Warning {
        private String file;
        private int line;
        private String msg;
        private int msgNum;

        public Warning(String file, int line, String msg, int msgNum) {
            this.file = file;
            this.line = line;
            this.msg = msg;
            this.msgNum = msgNum;
        }
    }

    private class WarningsProcessor
    implements LineProcessor<List<Warning>> {
        private List<Warning> results = new ArrayList<Warning>();

        private WarningsProcessor() {
        }

        public boolean processLine(String line) throws IOException {
            int pos1 = line.indexOf(93, 1);
            if (pos1 == -1) {
                return true;
            }
            int pos2 = line.indexOf(93, pos1 + 2);
            Integer lineNumber = Ints.tryParse((String)line.substring(1, pos1));
            String fileName = line.substring(pos1 + 3, pos2);
            String msg = line.substring(pos2 + 2);
            int lastOpeningParen = msg.lastIndexOf(40);
            int lastClosingParen = msg.lastIndexOf(41);
            Integer msgNum = -1;
            if (lastOpeningParen > -1 && lastClosingParen > -1) {
                msgNum = Ints.tryParse((String)msg.substring(lastOpeningParen + 1, lastClosingParen));
            }
            if (msgNum > -1) {
                msg = msg.substring(0, lastOpeningParen);
            }
            if (msg.startsWith("WARNING: ")) {
                msg = msg.substring(8);
            }
            this.results.add(new Warning(fileName, lineNumber == null ? 0 : lineNumber, msg.trim(), msgNum == null ? -1 : msgNum));
            return true;
        }

        public List<Warning> getResult() {
            return this.results;
        }
    }
}

