/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.spi;

import java.util.ArrayList;
import java.util.List;

public enum StringDelimiter {
    AMPERSAND("Ampersand", "&", "&"),
    AT_SIGN("AtSign", "@", "@"),
    BACKSLASH("Backslash", "\\\\", "\\"),
    COLON("Colon", ":", ":"),
    COMMA("Comma", ",", ","),
    DASH("Dash", "-", "-"),
    EQUAL("Equal", "=", "="),
    HASH("Hash", "#", "#"),
    MULTI_SPACE("MultiSpace", "\\s+", "    "),
    PERIOD("Period", "\\.", "."),
    PIPE("Pipe", "\\|", "|"),
    SEMICOLON("Semicolon", ";", ";"),
    SLASH("Slash", "/", "/"),
    SPACE("Space", "\\s", " "),
    UNDERSCORE("Underscore", "_", "_");

    private String name;
    private String regex;
    private String value;

    private StringDelimiter(String name, String regex, String value) {
        this.name = name;
        this.regex = regex;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getValue() {
        return this.value;
    }

    public static StringDelimiter fromName(String name) {
        for (StringDelimiter entry : StringDelimiter.values()) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public static List<String> getAllRegexes() {
        ArrayList<String> values = new ArrayList<String>();
        for (StringDelimiter en : StringDelimiter.values()) {
            values.add(en.getRegex());
        }
        return values;
    }

    public static List<String> getAllNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (StringDelimiter en : StringDelimiter.values()) {
            names.add(en.getName());
        }
        return names;
    }
}

