/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasValidationService;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.CompoundClassLoader;
import io.atlasmap.core.DefaultAtlasCombineStrategy;
import io.atlasmap.core.DefaultAtlasCompoundClassLoader;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.core.DefaultAtlasModuleInfo;
import io.atlasmap.core.DefaultAtlasModuleInfoRegistry;
import io.atlasmap.core.DefaultAtlasPreviewContext;
import io.atlasmap.core.DefaultAtlasPropertyStrategy;
import io.atlasmap.core.DefaultAtlasSeparateStrategy;
import io.atlasmap.core.DefaultAtlasValidationService;
import io.atlasmap.mxbean.AtlasContextFactoryMXBean;
import io.atlasmap.spi.AtlasCombineStrategy;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleInfo;
import io.atlasmap.spi.AtlasModuleInfoRegistry;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.spi.AtlasSeparateStrategy;
import io.atlasmap.v2.AtlasMapping;
import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasContextFactory
implements AtlasContextFactory,
AtlasContextFactoryMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasContextFactory.class);
    private static DefaultAtlasContextFactory factory = null;
    private boolean initialized = false;
    private String uuid = null;
    private String threadName = null;
    private ObjectName objectName = null;
    private DefaultAtlasConversionService atlasConversionService = null;
    private DefaultAtlasFieldActionService atlasFieldActionService = null;
    private AtlasCombineStrategy atlasCombineStrategy = null;
    private AtlasPropertyStrategy atlasPropertyStrategy = null;
    private AtlasSeparateStrategy atlasSeparateStrategy = null;
    private AtlasValidationService atlasValidationService = null;
    private AtlasModuleInfoRegistry moduleInfoRegistry;
    private Map<String, String> properties = null;
    private CompoundClassLoader classLoader = null;

    private DefaultAtlasContextFactory() {
    }

    public static DefaultAtlasContextFactory getInstance() {
        return DefaultAtlasContextFactory.getInstance(true);
    }

    public static DefaultAtlasContextFactory getInstance(boolean init) {
        if (factory == null) {
            factory = new DefaultAtlasContextFactory();
            if (init) {
                factory.init();
            }
        }
        return factory;
    }

    public synchronized void init() {
        DefaultAtlasCompoundClassLoader cl = new DefaultAtlasCompoundClassLoader();
        ((CompoundClassLoader)cl).addAlternativeLoader(AtlasMapping.class.getClassLoader());
        this.init(cl);
    }

    public synchronized void init(CompoundClassLoader cl) {
        if (this.initialized) {
            return;
        }
        this.uuid = UUID.randomUUID().toString();
        this.threadName = Thread.currentThread().getName();
        this.classLoader = cl;
        try {
            this.properties = new HashMap<String, String>();
            Properties props = new Properties();
            props.load(this.getClass().getClassLoader().getResourceAsStream("atlasmap.properties"));
            String version = props.getProperty("atlasmap.core.version");
            this.properties.put("atlasmap.core.version", version);
        }
        catch (Exception e) {
            LOG.debug("Failed to read atlasmap.properties", (Throwable)e);
        }
        this.atlasConversionService = DefaultAtlasConversionService.getInstance();
        this.atlasFieldActionService = DefaultAtlasFieldActionService.getInstance();
        this.atlasFieldActionService.init(this.classLoader);
        this.atlasCombineStrategy = new DefaultAtlasCombineStrategy();
        this.atlasPropertyStrategy = new DefaultAtlasPropertyStrategy();
        this.atlasSeparateStrategy = new DefaultAtlasSeparateStrategy();
        this.atlasValidationService = new DefaultAtlasValidationService();
        this.registerFactoryJmx(this);
        this.moduleInfoRegistry = new DefaultAtlasModuleInfoRegistry(this);
        this.loadModules("moduleClass", AtlasModule.class);
        this.initialized = true;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setProperties(Properties properties) {
        this.properties = new HashMap<String, String>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.properties.put(key.toString(), value.toString())));
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public synchronized void destroy() {
        if (!this.initialized) {
            return;
        }
        this.unloadModules();
        try {
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(this.getJmxObjectName())) {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.getJmxObjectName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unregistered AtlasContextFactory with JMX");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to unregister with JMX", (Throwable)e);
        }
        this.uuid = null;
        this.objectName = null;
        this.properties = null;
        this.atlasFieldActionService = null;
        this.atlasConversionService = null;
        this.atlasPropertyStrategy = null;
        this.atlasCombineStrategy = null;
        this.atlasSeparateStrategy = null;
        this.atlasValidationService = null;
        this.moduleInfoRegistry = null;
        this.classLoader = null;
        this.threadName = null;
        this.initialized = false;
    }

    public AtlasContext createContext(File atlasMappingFile) throws AtlasException {
        if (atlasMappingFile == null) {
            throw new AtlasException("AtlasMappingFile must be specified");
        }
        return this.createContext(atlasMappingFile.toURI());
    }

    public AtlasContext createContext(URI atlasMappingUri) throws AtlasException {
        if (atlasMappingUri == null) {
            throw new AtlasException("AtlasMappingUri must be specified");
        }
        DefaultAtlasContext context = new DefaultAtlasContext(this, atlasMappingUri);
        return context;
    }

    public AtlasContext createContext(AtlasMapping mapping) throws AtlasException {
        DefaultAtlasContext context = new DefaultAtlasContext(this, mapping);
        return context;
    }

    public AtlasContext createContext(AtlasContextFactory.Format format, InputStream stream) throws AtlasException {
        DefaultAtlasContext context = new DefaultAtlasContext(this, format, stream);
        return context;
    }

    public DefaultAtlasPreviewContext createPreviewContext() {
        DefaultAtlasPreviewContext context = new DefaultAtlasPreviewContext(this);
        return context;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public String getUuid() {
        return this.uuid;
    }

    public ObjectName getJmxObjectName() {
        return this.objectName;
    }

    public AtlasModuleInfoRegistry getModuleInfoRegistry() {
        return this.moduleInfoRegistry;
    }

    public void setModuleInfoRegistry(AtlasModuleInfoRegistry registry) {
        this.moduleInfoRegistry = registry;
    }

    public AtlasConversionService getConversionService() {
        return this.atlasConversionService;
    }

    public AtlasFieldActionService getFieldActionService() {
        return this.atlasFieldActionService;
    }

    public AtlasCombineStrategy getCombineStrategy() {
        return this.atlasCombineStrategy;
    }

    public void setCombineStrategy(AtlasCombineStrategy atlasCombineStrategy) {
        this.atlasCombineStrategy = atlasCombineStrategy;
    }

    public AtlasPropertyStrategy getPropertyStrategy() {
        return this.atlasPropertyStrategy;
    }

    public void setPropertyStrategy(AtlasPropertyStrategy atlasPropertyStrategy) {
        this.atlasPropertyStrategy = atlasPropertyStrategy;
    }

    public AtlasSeparateStrategy getSeparateStrategy() {
        return this.atlasSeparateStrategy;
    }

    public void setSeparateStrategy(AtlasSeparateStrategy atlasSeparateStrategy) {
        this.atlasSeparateStrategy = atlasSeparateStrategy;
    }

    public AtlasValidationService getValidationService() {
        return this.atlasValidationService;
    }

    public void setValidationService(AtlasValidationService atlasValidationService) {
        this.atlasValidationService = atlasValidationService;
    }

    public CompoundClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addClassLoader(ClassLoader cl) {
        this.classLoader.addAlternativeLoader(cl);
    }

    public void setClassLoader(CompoundClassLoader cl) {
        this.classLoader = cl;
    }

    protected void loadModules(String moduleClassProperty, Class<?> moduleInterface) {
        Class<AtlasModule> moduleClass = null;
        String moduleClassName = null;
        HashSet<String> serviceClasses = new HashSet<String>();
        try {
            Enumeration<URL> urls = this.classLoader.getResources("META-INF/services/atlas/module/atlas.module");
            while (urls.hasMoreElements()) {
                String[] splitted;
                URL tmp = urls.nextElement();
                Properties prop = AtlasUtil.loadPropertiesFromURL(tmp);
                String serviceClassPropertyValue = (String)prop.get(moduleClassProperty);
                for (String entry : splitted = serviceClassPropertyValue != null ? serviceClassPropertyValue.split(",") : new String[]{}) {
                    if (AtlasUtil.isEmpty(entry)) continue;
                    serviceClasses.add(entry);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error loading module resources", (Throwable)e);
        }
        for (String clazz : serviceClasses) {
            try {
                moduleClass = this.classLoader.loadClass(clazz);
                moduleClassName = moduleClass.getName();
                if (this.isClassAtlasModule(moduleClass, moduleInterface)) {
                    Class<AtlasModule> atlasModuleClass = moduleClass;
                    Constructor<AtlasModule> constructor = atlasModuleClass.getDeclaredConstructor(new Class[0]);
                    if (constructor != null) {
                        DefaultAtlasModuleInfo module = new DefaultAtlasModuleInfo(this.getModuleName(moduleClass), this.getModuleUri(moduleClass), atlasModuleClass, constructor, this.getSupportedDataFormats(moduleClass), this.getConfigPackages(moduleClass));
                        this.getModuleInfoRegistry().register((AtlasModuleInfo)module);
                        continue;
                    }
                    LOG.warn("Invalid module class {}: constructor is not present", (Object)moduleClassName);
                    continue;
                }
                LOG.warn("Invalid module class {}: unsupported AtlasModule", (Object)moduleClassName);
            }
            catch (NoSuchMethodException e) {
                LOG.warn(String.format("Invalid module class %s: constructor is not present.", moduleClassName), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.warn(String.format("Invalid module class %s: not found in classLoader.", moduleClassName), (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn(String.format("Invalid module class %s: unknown error.", moduleClassName), (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded: {} of {} detected modules", (Object)this.getModuleInfoRegistry().size(), (Object)serviceClasses.size());
        }
    }

    protected void unloadModules() {
        if (this.getModuleInfoRegistry() == null) {
            return;
        }
        int moduleCount = this.getModuleInfoRegistry().size();
        this.getModuleInfoRegistry().unregisterAll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unloaded: {} modules", (Object)moduleCount);
        }
    }

    protected boolean isClassAtlasModule(Class<?> clazz, Class<?> moduleInterface) {
        if (clazz == null) {
            return false;
        }
        if (this.isAtlasModuleInterface(clazz, moduleInterface) && clazz.isAnnotationPresent(AtlasModuleDetail.class)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is a '{}' implementation", (Object)clazz.getCanonicalName(), (Object)moduleInterface.getSimpleName());
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} is NOT a '{}' implementation", (Object)clazz.getCanonicalName(), (Object)moduleInterface.getSimpleName());
        }
        return false;
    }

    protected boolean isAtlasModuleInterface(Class<?> clazz, Class<?> moduleInterface) {
        Class<?>[] interfaces;
        if (clazz == null) {
            return false;
        }
        boolean isIface = false;
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            isIface = this.isAtlasModuleInterface(superClazz, moduleInterface);
        }
        for (Class<?> iface : interfaces = clazz.getInterfaces()) {
            if (!iface.equals(moduleInterface)) continue;
            isIface = true;
        }
        return isIface;
    }

    protected String getModuleUri(Class<?> clazz) {
        AtlasModuleDetail detail = clazz.getAnnotation(AtlasModuleDetail.class);
        if (detail != null) {
            return detail.uri();
        }
        return "UNDEFINED";
    }

    protected String getModuleName(Class<?> clazz) {
        AtlasModuleDetail detail = clazz.getAnnotation(AtlasModuleDetail.class);
        if (detail != null) {
            return detail.name();
        }
        return "UNDEFINED-" + UUID.randomUUID().toString();
    }

    protected List<String> getSupportedDataFormats(Class<?> clazz) {
        ArrayList<String> dataFormats = null;
        AtlasModuleDetail detail = clazz.getAnnotation(AtlasModuleDetail.class);
        if (detail != null) {
            String[] formats;
            dataFormats = new ArrayList<String>();
            for (String format : formats = detail.dataFormats()) {
                dataFormats.add(format.trim());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Module: {} supports data formats: {}", (Object)clazz.getCanonicalName(), dataFormats);
        }
        return dataFormats;
    }

    protected List<String> getConfigPackages(Class<?> clazz) {
        ArrayList<String> configPackages = null;
        AtlasModuleDetail detail = clazz.getAnnotation(AtlasModuleDetail.class);
        if (detail != null) {
            String[] packages;
            configPackages = new ArrayList<String>();
            for (String pkg : packages = detail.configPackages()) {
                configPackages.add(pkg.trim());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Module: {} config packages: {}", (Object)clazz.getCanonicalName(), configPackages);
        }
        return configPackages;
    }

    protected List<String> getAllModuleConfigPackages(AtlasModuleInfoRegistry registry) {
        ArrayList<String> pkgs = new ArrayList<String>();
        for (AtlasModuleInfo moduleInfo : registry.getAll()) {
            pkgs.addAll(Arrays.asList(moduleInfo.getPackageNames()));
        }
        return pkgs;
    }

    protected void registerFactoryJmx(DefaultAtlasContextFactory factory) {
        if (factory == null) {
            return;
        }
        try {
            factory.setObjectName();
            if (!ManagementFactory.getPlatformMBeanServer().isRegistered(factory.getJmxObjectName())) {
                ManagementFactory.getPlatformMBeanServer().registerMBean(factory, factory.getJmxObjectName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Registered AtlasContextFactory with JMX");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to resgister DefaultAtlasContextFactory with JMX", (Throwable)e);
        }
    }

    protected void setObjectName() throws MalformedObjectNameException {
        this.objectName = new ObjectName(String.format("io.atlasmap:type=AtlasServiceFactory,factoryUuid=%s", this.getUuid()));
    }
}

