/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasPreviewContext;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.core.DefaultAtlasCollectionHelper;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.AtlasCollectionHelper;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.SimpleField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultAtlasPreviewContext
extends DefaultAtlasContext
implements AtlasPreviewContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasPreviewContext.class);
    private Mapping mapping;
    private PreviewModule previewModule = new PreviewModule();
    private AtlasCollectionHelper collectionHelper;

    DefaultAtlasPreviewContext(DefaultAtlasContextFactory factory) {
        super(factory, new AtlasMapping());
        this.collectionHelper = new DefaultAtlasCollectionHelper(factory.getFieldActionService());
    }

    @Override
    public Audits processPreview(Mapping mapping) throws AtlasException {
        Field targetField;
        DefaultAtlasSession session = new DefaultAtlasSession(this);
        this.mapping = mapping;
        session.head().setMapping(mapping);
        MappingType mappingType = mapping.getMappingType();
        String expression = mapping.getExpression();
        FieldGroup sourceFieldGroup = mapping.getInputFieldGroup();
        List sourceFields = mapping.getInputField();
        List targetFields = mapping.getOutputField();
        targetFields.forEach(tf -> tf.setValue(null));
        if (sourceFieldGroup == null && sourceFields.isEmpty() || targetFields.isEmpty()) {
            return session.getAudits();
        }
        if (sourceFieldGroup != null) {
            sourceFields = sourceFieldGroup.getField();
        }
        for (Field sf : sourceFields) {
            if (sf.getFieldType() == null || sf.getValue() == null || sf.getValue() instanceof String && ((String)sf.getValue()).isEmpty() || this.restoreSourceFieldType(session, sf)) continue;
            return session.getAudits();
        }
        this.processSourceFieldMapping(session);
        if (session.hasErrors()) {
            return session.getAudits();
        }
        Field sourceField = session.head().getSourceField();
        if (mappingType == null || mappingType == MappingType.MAP) {
            sourceFieldGroup = sourceField instanceof FieldGroup ? (FieldGroup)sourceField : null;
            for (int i = 0; i < targetFields.size(); ++i) {
                targetField = (Field)targetFields.get(i);
                session.head().setTargetField(targetField);
                if (sourceFieldGroup != null) {
                    if (sourceFieldGroup.getField().size() == 0) {
                        AtlasUtil.addAudit((AtlasInternalSession)session, targetField, String.format("Skipping empty source group field '%s:%s'", sourceField.getDocId(), sourceField.getPath()), AuditStatus.INFO, null);
                        continue;
                    }
                    Integer index = targetField.getIndex();
                    AtlasPath targetPath = new AtlasPath(targetField.getPath());
                    if (targetPath.hasCollection() && !targetPath.isIndexedCollection()) {
                        if (targetFields.size() > 1) {
                            AtlasUtil.addAudit((AtlasInternalSession)session, targetField, "It's not yet supported to have a collection field as a part of multiple target fields in a same mapping", AuditStatus.ERROR, null);
                            return session.getAudits();
                        }
                        FieldGroup targetFieldGroup = targetField instanceof FieldGroup ? (FieldGroup)targetField : AtlasModelFactory.createFieldGroupFrom((Field)targetField, (boolean)true);
                        targetFields.set(i, targetFieldGroup);
                        SimpleField previousTargetField = null;
                        for (Field subSourceField : sourceFieldGroup.getField()) {
                            SimpleField subTargetField = AtlasModelFactory.cloneFieldToSimpleField((Field)targetFieldGroup);
                            targetFieldGroup.getField().add(subTargetField);
                            this.collectionHelper.copyCollectionIndexes((Field)sourceFieldGroup, subSourceField, (Field)subTargetField, previousTargetField);
                            previousTargetField = subTargetField;
                            if (!this.convertSourceToTarget(session, subSourceField, (Field)subTargetField)) {
                                return session.getAudits();
                            }
                            SimpleField processed = subTargetField;
                            if (expression == null || expression.isEmpty()) {
                                processed = this.applyFieldActions(session, (Field)subTargetField);
                            }
                            subTargetField.setValue(processed.getValue());
                        }
                        continue;
                    }
                    if (index == null) {
                        session.head().setSourceField((Field)sourceFieldGroup.getField().get(sourceFieldGroup.getField().size() - 1));
                    } else if (sourceFieldGroup.getField().size() > index) {
                        session.head().setSourceField((Field)sourceFieldGroup.getField().get(index));
                    } else {
                        AtlasUtil.addAudit((AtlasInternalSession)session, targetField, String.format("The number of source fields '%s' is fewer than expected via target field index '%s'", sourceFieldGroup.getField().size(), targetField.getIndex()), AuditStatus.WARN, null);
                        continue;
                    }
                }
                if (session.hasErrors()) {
                    return session.getAudits();
                }
                if (!this.convertSourceToTarget(session, session.head().getSourceField(), targetField)) {
                    return session.getAudits();
                }
                Field processed = targetField;
                if (expression == null || expression.isEmpty()) {
                    processed = this.applyFieldActions(session, targetField);
                }
                targetField.setValue(processed.getValue());
            }
        } else if (mappingType == MappingType.COMBINE) {
            targetField = (Field)targetFields.get(0);
            Field combined = this.processCombineField(session, mapping, sourceFields, targetField);
            if (!this.convertSourceToTarget(session, combined, targetField)) {
                return session.getAudits();
            }
            this.applyFieldActions(session, targetField);
        } else if (mappingType == MappingType.SEPARATE) {
            List<Field> separatedFields;
            try {
                separatedFields = this.processSeparateField(session, mapping, sourceField);
            }
            catch (AtlasException e) {
                AtlasUtil.addAudit((AtlasInternalSession)session, sourceField, String.format("Failed to separate field: %s", AtlasUtil.getChainedMessage(e)), AuditStatus.ERROR, null);
                if (LOG.isDebugEnabled()) {
                    LOG.error("", (Throwable)e);
                }
                return session.getAudits();
            }
            if (separatedFields == null) {
                return session.getAudits();
            }
            for (Field f : targetFields) {
                targetField = f;
                if (targetField.getIndex() == null || targetField.getIndex() < 0) {
                    AtlasUtil.addAudit((AtlasInternalSession)session, targetField, String.format("Separate requires zero or positive Index value to be set on targetField targetField.path=%s", targetField.getPath()), AuditStatus.WARN, null);
                    continue;
                }
                if (separatedFields.size() <= targetField.getIndex()) {
                    String errorMessage = String.format("Separate returned fewer segments count=%s when targetField.path=%s requested index=%s", separatedFields.size(), targetField.getPath(), targetField.getIndex());
                    AtlasUtil.addAudit((AtlasInternalSession)session, targetField, errorMessage, AuditStatus.WARN, null);
                } else if (this.convertSourceToTarget(session, separatedFields.get(targetField.getIndex()), targetField)) {
                    this.applyFieldActions(session, targetField);
                    continue;
                }
                break;
            }
        } else {
            AtlasUtil.addAudit((AtlasInternalSession)session, (String)null, String.format("Unsupported mappingType=%s detected", mapping.getMappingType()), AuditStatus.ERROR, null);
        }
        return session.getAudits();
    }

    private boolean restoreSourceFieldType(DefaultAtlasSession session, Field sourceField) throws AtlasException {
        try {
            Object sourceValue = this.getContextFactory().getConversionService().convertType(sourceField.getValue(), null, sourceField.getFieldType(), null);
            sourceField.setValue(sourceValue);
        }
        catch (AtlasConversionException e) {
            AtlasUtil.addAudit((AtlasInternalSession)session, sourceField, String.format("Wrong format for source value : %s", AtlasUtil.getChainedMessage(e)), AuditStatus.ERROR, null);
            if (LOG.isDebugEnabled()) {
                LOG.error("", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private boolean convertSourceToTarget(DefaultAtlasSession session, Field sourceField, Field targetField) throws AtlasException {
        Object targetValue = null;
        if (sourceField.getFieldType() != null && sourceField.getFieldType().equals((Object)targetField.getFieldType())) {
            targetValue = sourceField.getValue();
        } else if (sourceField.getValue() != null) {
            try {
                targetValue = this.getContextFactory().getConversionService().convertType(sourceField.getValue(), sourceField.getFormat(), targetField.getFieldType(), targetField.getFormat());
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasInternalSession)session, targetField, String.format("Failed to convert source value to target type: %s", AtlasUtil.getChainedMessage(e)), AuditStatus.ERROR, null);
                if (LOG.isDebugEnabled()) {
                    LOG.error("", (Throwable)e);
                }
                return false;
            }
        }
        targetField.setValue(targetValue);
        return true;
    }

    @Override
    public Map<String, AtlasModule> getSourceModules() {
        return new HashMap<String, AtlasModule>(){
            private static final long serialVersionUID = 1L;

            @Override
            public AtlasModule get(Object key) {
                return DefaultAtlasPreviewContext.this.previewModule;
            }
        };
    }

    @Override
    protected AtlasModule resolveModule(FieldDirection direction, Field field) {
        return this.previewModule;
    }

    private class PreviewModule
    extends BaseAtlasModule {
        private PreviewModule() {
        }

        public void readSourceValue(AtlasInternalSession session) throws AtlasException {
            Field sourceField = session.head().getSourceField();
            FieldGroup sourceFieldGroup = DefaultAtlasPreviewContext.this.mapping.getInputFieldGroup();
            if (sourceFieldGroup != null) {
                if (this.matches(sourceField, (Field)sourceFieldGroup)) {
                    session.head().setSourceField((Field)sourceFieldGroup);
                    return;
                }
                Field f = this.readFromGroup(sourceFieldGroup, sourceField);
                session.head().setSourceField(f);
                return;
            }
            for (Field f : DefaultAtlasPreviewContext.this.mapping.getInputField()) {
                if (!this.matches(sourceField, f)) continue;
                session.head().setSourceField(f);
                return;
            }
        }

        private boolean matches(Field f1, Field f2) {
            if (f1.getDocId() == null && f2.getDocId() != null || f1.getDocId() != null && f2.getDocId() == null || f1.getDocId() != null && !f1.getDocId().equals(f2.getDocId())) {
                return false;
            }
            return f2.getPath() != null && f2.getPath().equals(f1.getPath());
        }

        private Field readFromGroup(FieldGroup group, Field field) {
            if (group.getField() == null) {
                return null;
            }
            for (Field f : group.getField()) {
                Field deeper;
                if (this.matches(field, f)) {
                    return f;
                }
                if (!(f instanceof FieldGroup) || (deeper = this.readFromGroup((FieldGroup)f, field)) == null) continue;
                return deeper;
            }
            return null;
        }

        @Override
        public Boolean isSupportedField(Field field) {
            return true;
        }

        public void processPreValidation(AtlasInternalSession session) throws AtlasException {
        }

        public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
        }

        public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
        }

        public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        }

        public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
        }

        public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        }

        public Field cloneField(Field field) throws AtlasException {
            return null;
        }

        @Override
        public String getDocName() {
            return "Preview";
        }

        @Override
        public String getDocId() {
            return "Preview";
        }
    }
}

