/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.spi.AtlasSeparateStrategy;
import io.atlasmap.spi.StringDelimiter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultAtlasSeparateStrategy
implements AtlasSeparateStrategy {
    public static final Integer DEFAULT_SEPARATE_LIMIT = new Integer(512);
    public static final StringDelimiter DEFAULT_SEPARATE_DELIMITER = StringDelimiter.MULTI_SPACE;
    private StringDelimiter delimiter = DEFAULT_SEPARATE_DELIMITER;
    private Integer limit = DEFAULT_SEPARATE_LIMIT;

    public StringDelimiter getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(StringDelimiter delimiter) {
        this.delimiter = delimiter;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public List<String> separateValue(String value) {
        return this.separateValue(value, this.getDelimiter(), this.getLimit());
    }

    public List<String> separateValue(String value, StringDelimiter delimiter) {
        return this.separateValue(value, delimiter, this.getLimit());
    }

    public List<String> separateValue(String value, StringDelimiter delimiter, Integer limit) {
        ArrayList<String> values = new ArrayList<String>();
        if (value == null || value.isEmpty()) {
            return values;
        }
        values.addAll(Arrays.asList(value.split(delimiter == null ? DEFAULT_SEPARATE_DELIMITER.getRegex() : delimiter.getRegex(), limit == null ? DEFAULT_SEPARATE_LIMIT : limit)));
        return values;
    }
}

