/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.DefaultAtlasCombineStrategy;
import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.util.Map;

public class TemplateCombineStrategy
extends DefaultAtlasCombineStrategy {
    @Override
    public String combineValues(Map<Integer, String> values, String template) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (template == null || template.isEmpty()) {
            return this.combineValues(values);
        }
        StringBuilder templateBuilder = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(template);
        boolean escaped = false;
        char chr = iter.first();
        while (chr != '\uffff') {
            templateBuilder.append(chr);
            if (chr == '\'' && !escaped) {
                escaped = true;
            } else {
                if (chr == '{' && !escaped) {
                    StringBuilder indexBuilder = new StringBuilder();
                    chr = iter.next();
                    while (Character.isDigit(chr)) {
                        indexBuilder.append(chr);
                        chr = iter.next();
                    }
                    templateBuilder.append(Integer.valueOf(indexBuilder.toString()) - 1);
                    templateBuilder.append(chr);
                }
                escaped = false;
            }
            chr = iter.next();
        }
        values = DefaultAtlasCombineStrategy.sortByKey(values);
        return MessageFormat.format(templateBuilder.toString(), values.values().toArray());
    }
}

