/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NotEmptyValidator
implements AtlasValidator {
    private String violationMessage;
    private ValidationScope scope;

    public NotEmptyValidator(ValidationScope scope, String violationMessage) {
        this.violationMessage = violationMessage;
        this.scope = scope;
    }

    public boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(List.class) || clazz.isAssignableFrom(Map.class) || clazz.isAssignableFrom(Set.class) || clazz.isAssignableFrom(Collection.class);
    }

    public boolean supports(Object object) {
        return object instanceof List || object instanceof Map || object instanceof Set || object instanceof Collection;
    }

    public void validate(Object target, List<Validation> validations, String id) {
        this.validate(target, validations, id, ValidationStatus.ERROR);
    }

    public void validate(Object target, List<Validation> validations, String id, ValidationStatus status) {
        if (!this.supports(target)) {
            return;
        }
        if (((Collection)target).isEmpty()) {
            Validation validation = new Validation();
            validation.setScope(this.scope);
            validation.setId(id);
            validation.setMessage(this.violationMessage);
            validation.setStatus(status);
            validations.add(validation);
        }
    }
}

