/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.v2;

import io.atlasmap.java.v2.JavaClass;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaEnumFields;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.java.v2.JavaFields;
import io.atlasmap.java.v2.ModifierList;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import java.util.ArrayList;

public class AtlasJavaModelFactory {
    public static final String URI_FORMAT = "atlas:java?className=%s";

    public static JavaClass createJavaClass() {
        JavaClass javaClass = new JavaClass();
        javaClass.setJavaEnumFields(new JavaEnumFields());
        javaClass.setJavaFields(new JavaFields());
        return javaClass;
    }

    public static JavaField createJavaField() {
        JavaField javaField = new JavaField();
        javaField.setModifiers(new ModifierList());
        return javaField;
    }

    public static FieldGroup cloneFieldGroup(FieldGroup group) {
        FieldGroup clone = AtlasModelFactory.copyFieldGroup((FieldGroup)group);
        ArrayList<Object> newChildren = new ArrayList<Object>();
        for (Field child : group.getField()) {
            if (child instanceof FieldGroup) {
                newChildren.add(AtlasJavaModelFactory.cloneFieldGroup((FieldGroup)child));
                continue;
            }
            newChildren.add(AtlasJavaModelFactory.cloneJavaField(child, true));
        }
        clone.getField().addAll(newChildren);
        return clone;
    }

    public static Field cloneJavaField(Field field, boolean withActions) {
        if (field instanceof FieldGroup) {
            FieldGroup clone = AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)withActions);
            for (Field f : ((FieldGroup)field).getField()) {
                clone.getField().add(AtlasJavaModelFactory.cloneJavaField(f, withActions));
            }
            return clone;
        }
        Field clone = field instanceof JavaEnumField ? new JavaEnumField() : new JavaField();
        AtlasJavaModelFactory.copyField(field, clone, withActions);
        return clone;
    }

    public static void copyField(Field from, Field to, boolean withActions) {
        AtlasModelFactory.copyField((Field)from, (Field)to, (boolean)withActions);
        if (from instanceof JavaField && to instanceof JavaField) {
            JavaField fromJava = (JavaField)from;
            JavaField toJava = (JavaField)to;
            toJava.setAnnotations(fromJava.getAnnotations());
            toJava.setClassName(fromJava.getClassName());
            toJava.setCollectionClassName(fromJava.getCollectionClassName());
            toJava.setGetMethod(fromJava.getGetMethod());
            toJava.setModifiers(fromJava.getModifiers());
            toJava.setName(fromJava.getName());
            toJava.setParameterizedTypes(fromJava.getParameterizedTypes());
            toJava.setPrimitive(fromJava.isPrimitive());
            toJava.setSetMethod(fromJava.getSetMethod());
            toJava.setSynthetic(fromJava.isSynthetic());
            return;
        }
        if (from instanceof JavaEnumField && to instanceof JavaEnumField) {
            JavaEnumField fromEnum = (JavaEnumField)from;
            JavaEnumField toEnum = (JavaEnumField)to;
            toEnum.setClassName(fromEnum.getClassName());
            toEnum.setName(fromEnum.getName());
            toEnum.setOrdinal(fromEnum.getOrdinal());
            return;
        }
        throw new RuntimeException(String.format("Unsupported field type to copy: from=%s, to=%s", from, to));
    }
}

