/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.config;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public enum Architecture {
    DEFAULT(Collections.emptyList()),
    X32(Arrays.asList("i686", "x86")),
    X64(Collections.emptyList());

    List<String> archLabels;

    private Architecture(List<String> archLabels) {
        this.archLabels = archLabels;
    }

    public Stream<String> archLabelsStream() {
        return this.archLabels.stream();
    }

    public boolean matchUrl(URL url) {
        return this.archLabelsStream().anyMatch(x -> url.getFile().contains((CharSequence)x)) || url.getFile().contains(this.toString());
    }

    public String toString() {
        return this.name().contains("X") ? this.name().replace("X", "") : this.name();
    }
}

