/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.online;

import com.google.gson.annotations.SerializedName;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class BitBucketApi {
    private int pagelen;
    private int size;
    private List<BitBucketValue> values;

    public int getPagelen() {
        return this.pagelen;
    }

    public int getSize() {
        return this.size;
    }

    public List<BitBucketValue> getValues() {
        return this.values;
    }

    public List<URL> getUrls() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (BitBucketValue value : this.getValues()) {
            urls.add(new URL(value.getLinks().getSelf().getHref()));
        }
        return urls;
    }

    class BitBucketSelf {
        private String href;

        BitBucketSelf() {
        }

        public String getHref() {
            return this.href;
        }
    }

    class BitBucketLink {
        private BitBucketSelf self;

        BitBucketLink() {
        }

        public BitBucketSelf getSelf() {
            return this.self;
        }
    }

    class BitBucketValue {
        private String name;
        private BitBucketLink links;
        private int downloads;
        @SerializedName(value="created_on")
        private String createOn;
        private Object user;
        private String type;
        private int size;

        BitBucketValue() {
        }

        public String getName() {
            return this.name;
        }

        public BitBucketLink getLinks() {
            return this.links;
        }

        public int getDownloads() {
            return this.downloads;
        }

        public String getCreateOn() {
            return this.createOn;
        }

        public Object getUser() {
            return this.user;
        }

        public String getType() {
            return this.type;
        }

        public int getSize() {
            return this.size;
        }
    }
}

