/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonathanlink;

import io.github.jonathanlink.Character;
import io.github.jonathanlink.CharacterFactory;
import io.github.jonathanlink.TextLine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.text.TextPositionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFLayoutTextStripper
extends PDFTextStripper {
    public static final boolean DEBUG = false;
    public static final int OUTPUT_SPACE_CHARACTER_WIDTH_IN_PT = 4;
    private double currentPageWidth;
    private TextPosition previousTextPosition = null;
    private List<TextLine> textLineList = new ArrayList<TextLine>();

    public void processPage(PDPage page) throws IOException {
        PDRectangle pageRectangle = page.getMediaBox();
        if (pageRectangle != null) {
            this.setCurrentPageWidth(pageRectangle.getWidth());
            super.processPage(page);
            this.previousTextPosition = null;
            this.textLineList = new ArrayList<TextLine>();
        }
    }

    protected void writePage() throws IOException {
        List charactersByArticle = super.getCharactersByArticle();
        for (int i = 0; i < charactersByArticle.size(); ++i) {
            List textList = (List)charactersByArticle.get(i);
            try {
                this.sortTextPositionList(textList);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e);
            }
            this.iterateThroughTextList(textList.iterator());
        }
        this.writeToOutputStream(this.getTextLineList());
    }

    private void writeToOutputStream(List<TextLine> textLineList) throws IOException {
        for (TextLine textLine : textLineList) {
            char[] line = textLine.getLine().toCharArray();
            super.getOutput().write(line);
            super.getOutput().write(10);
            super.getOutput().flush();
        }
    }

    private void sortTextPositionList(List<TextPosition> textList) {
        TextPositionComparator comparator = new TextPositionComparator();
        Collections.sort(textList, comparator);
    }

    private void writeLine(List<TextPosition> textPositionList) {
        if (textPositionList.size() > 0) {
            TextLine textLine = this.addNewLine();
            boolean firstCharacterOfLineFound = false;
            for (TextPosition textPosition : textPositionList) {
                CharacterFactory characterFactory = new CharacterFactory(firstCharacterOfLineFound);
                Character character = characterFactory.createCharacterFromTextPosition(textPosition, this.getPreviousTextPosition());
                textLine.writeCharacterAtIndex(character);
                this.setPreviousTextPosition(textPosition);
                firstCharacterOfLineFound = true;
            }
        } else {
            this.addNewLine();
        }
    }

    private void iterateThroughTextList(Iterator<TextPosition> textIterator) {
        ArrayList<TextPosition> textPositionList = new ArrayList<TextPosition>();
        while (textIterator.hasNext()) {
            TextPosition textPosition = textIterator.next();
            int numberOfNewLines = this.getNumberOfNewLinesFromPreviousTextPosition(textPosition);
            if (numberOfNewLines == 0) {
                textPositionList.add(textPosition);
            } else {
                this.writeTextPositionList(textPositionList);
                this.createNewEmptyNewLines(numberOfNewLines);
                textPositionList.add(textPosition);
            }
            this.setPreviousTextPosition(textPosition);
        }
        if (!textPositionList.isEmpty()) {
            this.writeTextPositionList(textPositionList);
        }
    }

    private void writeTextPositionList(List<TextPosition> textPositionList) {
        this.writeLine(textPositionList);
        textPositionList.clear();
    }

    private void createNewEmptyNewLines(int numberOfNewLines) {
        for (int i = 0; i < numberOfNewLines - 1; ++i) {
            this.addNewLine();
        }
    }

    private int getNumberOfNewLinesFromPreviousTextPosition(TextPosition textPosition) {
        float previousTextYPosition;
        TextPosition previousTextPosition = this.getPreviousTextPosition();
        if (previousTextPosition == null) {
            return 1;
        }
        float textYPosition = Math.round(textPosition.getY());
        if (textYPosition > (previousTextYPosition = (float)Math.round(previousTextPosition.getY())) && (double)(textYPosition - previousTextYPosition) > 5.5) {
            double height = textPosition.getHeight();
            int numberOfLines = (int)(Math.floor(textYPosition - previousTextYPosition) / height);
            numberOfLines = Math.max(1, numberOfLines - 1);
            return numberOfLines;
        }
        return 0;
    }

    private TextLine addNewLine() {
        TextLine textLine = new TextLine(this.getCurrentPageWidth());
        this.textLineList.add(textLine);
        return textLine;
    }

    private TextPosition getPreviousTextPosition() {
        return this.previousTextPosition;
    }

    private void setPreviousTextPosition(TextPosition setPreviousTextPosition) {
        this.previousTextPosition = setPreviousTextPosition;
    }

    private int getCurrentPageWidth() {
        return (int)Math.round(this.currentPageWidth);
    }

    private void setCurrentPageWidth(double currentPageWidth) {
        this.currentPageWidth = currentPageWidth;
    }

    private List<TextLine> getTextLineList() {
        return this.textLineList;
    }
}

