/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.RequiredTypeException;
import io.jsonwebtoken.impl.JwtMap;
import java.util.Date;
import java.util.Map;

public class DefaultClaims
extends JwtMap
implements Claims {
    public DefaultClaims() {
    }

    public DefaultClaims(Map<String, Object> map) {
        super(map);
    }

    @Override
    public String getIssuer() {
        return this.getString("iss");
    }

    @Override
    public Claims setIssuer(String iss) {
        this.setValue("iss", iss);
        return this;
    }

    @Override
    public String getSubject() {
        return this.getString("sub");
    }

    @Override
    public Claims setSubject(String sub) {
        this.setValue("sub", sub);
        return this;
    }

    @Override
    public String getAudience() {
        return this.getString("aud");
    }

    @Override
    public Claims setAudience(String aud) {
        this.setValue("aud", aud);
        return this;
    }

    @Override
    public Date getExpiration() {
        return this.get("exp", Date.class);
    }

    @Override
    public Claims setExpiration(Date exp) {
        this.setDate("exp", exp);
        return this;
    }

    @Override
    public Date getNotBefore() {
        return this.get("nbf", Date.class);
    }

    @Override
    public Claims setNotBefore(Date nbf) {
        this.setDate("nbf", nbf);
        return this;
    }

    @Override
    public Date getIssuedAt() {
        return this.get("iat", Date.class);
    }

    @Override
    public Claims setIssuedAt(Date iat) {
        this.setDate("iat", iat);
        return this;
    }

    @Override
    public String getId() {
        return this.getString("jti");
    }

    @Override
    public Claims setId(String jti) {
        this.setValue("jti", jti);
        return this;
    }

    @Override
    public <T> T get(String claimName, Class<T> requiredType) {
        Object value = this.get(claimName);
        if (value == null) {
            return null;
        }
        if ("exp".equals(claimName) || "iat".equals(claimName) || "nbf".equals(claimName)) {
            value = this.getDate(claimName);
        }
        if (requiredType == Date.class && value instanceof Long) {
            value = new Date((Long)value);
        }
        if (!requiredType.isInstance(value)) {
            throw new RequiredTypeException("Expected value to be of type: " + requiredType + ", but was " + value.getClass());
        }
        return requiredType.cast(value);
    }
}

