/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.runtime.continuoustesting.ContinuousTestingJsonRPCService;
import io.quarkus.devui.runtime.continuoustesting.ContinuousTestingRecorder;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.runtime.ShutdownContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;

public class ContinuousTestingProcessor {
    private static final String NAMESPACE = "devui-continuous-testing";

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsLocalDevelopment.class})
    public void continuousTestingState(ContinuousTestingRecorder recorder, LaunchModeBuildItem launchModeBuildItem, ShutdownContextBuildItem shutdownContextBuildItem, BeanContainerBuildItem beanContainer) throws IOException {
        DevModeType devModeType = launchModeBuildItem.getDevModeType().orElse(null);
        if (devModeType == null || !devModeType.isContinuousTestingSupported()) {
            return;
        }
        if (TestSupport.instance().isPresent()) {
            recorder.createContinuousTestingSharedStateManager(beanContainer.getValue(), (ShutdownContext)shutdownContextBuildItem);
        }
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    InternalPageBuildItem createContinuousTestingPages() {
        InternalPageBuildItem continuousTestingPages = new InternalPageBuildItem("Continuous Testing", 30, "qwc-continuous-testing-menu-action");
        continuousTestingPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace(NAMESPACE)).title("Continuous Testing")).icon("font-awesome-solid:flask-vial")).componentLink("qwc-continuous-testing.js"));
        return continuousTestingPages;
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void registerBuildTimeActions(LaunchModeBuildItem launchModeBuildItem, BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer) {
        BuildTimeActionBuildItem actions = new BuildTimeActionBuildItem(NAMESPACE);
        this.registerStartMethod(launchModeBuildItem, actions);
        this.registerStopMethod(launchModeBuildItem, actions);
        this.registerRunAllMethod(launchModeBuildItem, actions);
        this.registerRunFailedMethod(launchModeBuildItem, actions);
        this.registerToggleBrokenOnlyMethod(launchModeBuildItem, actions);
        this.registerToggleInstrumentationMethod(launchModeBuildItem, actions);
        this.registerGetResultsMethod(launchModeBuildItem, actions);
        this.registerGetStatusMethod(launchModeBuildItem, actions);
        buildTimeActionProducer.produce((BuildItem)actions);
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(NAMESPACE, ContinuousTestingJsonRPCService.class);
    }

    private boolean testsDisabled(LaunchModeBuildItem launchModeBuildItem, Optional<TestSupport> ts) {
        return ts.isEmpty() || launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL;
    }

    private void registerStartMethod(LaunchModeBuildItem launchModeBuildItem, BuildTimeActionBuildItem actions) {
        actions.actionBuilder().methodName("start").description("Start the Continuous Testing").function(ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                if (testSupport.isStarted()) {
                    return false;
                }
                testSupport.start();
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).enableMcpFuctionByDefault().build();
    }

    private void registerStopMethod(LaunchModeBuildItem launchModeBuildItem, BuildTimeActionBuildItem actions) {
        actions.actionBuilder().methodName("stop").description("Stop the Continuous Testing").function(ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                if (testSupport.isStarted()) {
                    testSupport.stop();
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).enableMcpFuctionByDefault().build();
    }

    private void registerRunAllMethod(LaunchModeBuildItem launchModeBuildItem, BuildTimeActionBuildItem actions) {
        actions.actionBuilder().methodName("runAll").description("Run all tests in Continuous Testing if it's started").function(ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                testSupport.runAllTests();
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).enableMcpFuctionByDefault().build();
    }

    private void registerRunFailedMethod(LaunchModeBuildItem launchModeBuildItem, BuildTimeActionBuildItem actions) {
        actions.actionBuilder().methodName("runFailed").description("Run all failed tests in Continuous Testing if it's started").function(ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                testSupport.runFailedTests();
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).build();
    }

    private void registerToggleBrokenOnlyMethod(LaunchModeBuildItem launchModeBuildItem, BuildTimeActionBuildItem actions) {
        actions.actionBuilder().methodName("toggleBrokenOnly").description("Toggle broken only in Continuous Testing").function(ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                return testSupport.toggleBrokenOnlyMode();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).build();
    }

    private void registerToggleInstrumentationMethod(LaunchModeBuildItem launchModeBuildItem, BuildTimeActionBuildItem actions) {
        actions.actionBuilder().methodName("toggleInstrumentation").description("Toggle instrumentation in Continuous Testing").function(ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                return testSupport.toggleInstrumentation();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).build();
    }

    private void registerGetStatusMethod(LaunchModeBuildItem launchModeBuildItem, BuildTimeActionBuildItem actions) {
        actions.actionBuilder().methodName("getStatus").description("Get the status of Continuous Testing").function(ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return null;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                TestSupport.RunStatus status = testSupport.getStatus();
                if (status == null) {
                    return null;
                }
                HashMap<String, Long> testStatus = new HashMap<String, Long>();
                long lastRun = status.getLastRun();
                testStatus.put("lastRun", lastRun);
                if (lastRun > 0L) {
                    TestRunResults result = testSupport.getResults();
                    testStatus.put("testsFailed", result.getCurrentFailedCount());
                    testStatus.put("testsPassed", result.getCurrentPassedCount());
                    testStatus.put("testsSkipped", result.getCurrentSkippedCount());
                    testStatus.put("testsRun", result.getFailedCount() + result.getPassedCount());
                    testStatus.put("totalTestsFailed", result.getFailedCount());
                    testStatus.put("totalTestsPassed", result.getPassedCount());
                    testStatus.put("totalTestsSkipped", result.getSkippedCount());
                }
                testStatus.put("running", status.getRunning());
                return testStatus;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).enableMcpFuctionByDefault().build();
    }

    private void registerGetResultsMethod(LaunchModeBuildItem launchModeBuildItem, BuildTimeActionBuildItem actions) {
        actions.actionBuilder().methodName("getResults").description("Get the results of a Continuous testing test run").function(ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return null;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                TestRunResults testRunResults = testSupport.getResults();
                if (testRunResults == null) {
                    return null;
                }
                return testRunResults;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).build();
    }
}

