/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.mcp;

import io.quarkus.devui.runtime.mcp.McpClientInfo;
import io.quarkus.devui.runtime.spi.McpEvent;
import io.quarkus.devui.runtime.spi.McpServerConfiguration;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;

@ApplicationScoped
public class McpDevUIJsonRpcService {
    private static final Logger LOG = Logger.getLogger((String)McpDevUIJsonRpcService.class.getName());
    private final BroadcastProcessor<McpClientInfo> connectedClientStream = BroadcastProcessor.create();
    private final BroadcastProcessor<McpEvent> mcpEventStream = BroadcastProcessor.create();
    private final Set<McpClientInfo> connectedClients = new HashSet<McpClientInfo>();
    private McpServerConfiguration mcpServerConfiguration;
    private final Path configDir = Paths.get(System.getProperty("user.home"), ".quarkus");
    private final Path configFile = this.configDir.resolve("dev-mcp.properties");

    @PostConstruct
    public void init() {
        this.mcpServerConfiguration = new McpServerConfiguration(this.loadConfiguration());
    }

    public Set<McpClientInfo> getConnectedClients() {
        if (!this.connectedClients.isEmpty()) {
            return this.connectedClients;
        }
        return null;
    }

    public Multi<McpClientInfo> getConnectedClientStream() {
        return this.connectedClientStream;
    }

    @Produces
    public Multi<McpEvent> getEventStream() {
        return this.mcpEventStream;
    }

    public void addClientInfo(McpClientInfo clientInfo) {
        this.connectedClients.add(clientInfo);
        this.connectedClientStream.onNext((Object)clientInfo);
    }

    @Produces
    public McpServerConfiguration getMcpServerConfiguration() {
        return this.mcpServerConfiguration;
    }

    public McpServerConfiguration enable() {
        this.mcpServerConfiguration.enable();
        this.storeConfiguration(this.mcpServerConfiguration.toProperties());
        this.mcpEventStream.onNext((Object)new McpEvent(true));
        return this.mcpServerConfiguration;
    }

    public McpServerConfiguration disable() {
        this.mcpServerConfiguration.disable();
        this.storeConfiguration(this.mcpServerConfiguration.toProperties());
        this.mcpEventStream.onNext((Object)new McpEvent(false));
        return this.mcpServerConfiguration;
    }

    public McpServerConfiguration enableMethod(String name) {
        this.mcpServerConfiguration.enableMethod(name);
        this.storeConfiguration(this.mcpServerConfiguration.toProperties());
        return this.mcpServerConfiguration;
    }

    public McpServerConfiguration disableMethod(String name) {
        this.mcpServerConfiguration.disableMethod(name);
        this.storeConfiguration(this.mcpServerConfiguration.toProperties());
        return this.mcpServerConfiguration;
    }

    public boolean isExplicitlyEnabled(String methodName) {
        return this.mcpServerConfiguration.isExplicitlyEnabled(methodName);
    }

    public boolean isExplicitlyDisabled(String methodName) {
        return this.mcpServerConfiguration.isExplicitlyDisabled(methodName);
    }

    private Properties loadConfiguration() {
        Properties existingProps = new Properties();
        if (Files.exists(this.configFile, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(this.configFile, new OpenOption[0]);){
                existingProps.load(in);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return existingProps;
    }

    private boolean storeConfiguration(Properties p) {
        boolean bl;
        block11: {
            Files.createDirectories(this.configDir, new FileAttribute[0]);
            OutputStream out = Files.newOutputStream(this.configFile, new OpenOption[0]);
            try {
                p.store(out, "Dev MCP Configuration");
                bl = true;
                if (out == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        LOG.error((Object)("Could not create config file for Dev MCP [" + String.valueOf(this.configFile) + "]"), (Throwable)ex);
                        return false;
                    }
                }
                catch (IOException ex) {
                    LOG.error((Object)("Could not create config directory for Dev MCP [" + String.valueOf(this.configDir) + "]"), (Throwable)ex);
                    return false;
                }
            }
            out.close();
        }
        return bl;
    }
}

