/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusWorkerPoolRegistry;
import io.quarkus.smallrye.reactivemessaging.runtime.SmallRyeReactiveMessagingRecorder;
import io.quarkus.smallrye.reactivemessaging.runtime.WorkerConfiguration;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.providers.extension.ChannelConfiguration;
import io.smallrye.reactive.messaging.providers.extension.MediatorManager;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.inject.Inject;

@Dependent
public class SmallRyeReactiveMessagingLifecycle {
    @Inject
    MediatorManager mediatorManager;

    void onStaticInit(@Observes @Initialized(value=ApplicationScoped.class) Object event, SmallRyeReactiveMessagingRecorder.SmallRyeReactiveMessagingContext context, QuarkusWorkerPoolRegistry workerPoolRegistry) {
        this.mediatorManager.addAnalyzed(context.getMediatorConfigurations());
        for (WorkerConfiguration worker : context.getWorkerConfigurations()) {
            workerPoolRegistry.defineWorker(worker.getClassName(), worker.getMethodName(), worker.getPoolName(), worker.isVirtualThread());
        }
        for (EmitterConfiguration emitter : context.getEmitterConfigurations()) {
            this.mediatorManager.addEmitter(emitter);
        }
        for (ChannelConfiguration channel : context.getChannelConfigurations()) {
            this.mediatorManager.addChannel(channel);
        }
    }

    void onApplicationStart(@Observes @Priority(value=1000) StartupEvent event) {
        ManagedContext requestContext = Arc.container().requestContext();
        boolean isRequestScopeActive = requestContext.isActive();
        InjectableContext.ContextState state = null;
        if (isRequestScopeActive) {
            state = requestContext.getState();
            requestContext.deactivate();
        }
        try {
            this.mediatorManager.start();
        }
        catch (Exception e) {
            if (e instanceof DeploymentException || e instanceof DefinitionException) {
                throw e;
            }
            throw new DeploymentException((Throwable)e);
        }
        finally {
            if (state != null) {
                requestContext.activate(state);
            }
        }
    }
}

