/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import com.cronutils.Function;
import com.cronutils.mapper.CronMapper;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.SingleCron;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.QuestionMark;
import java.util.ArrayList;
import java.util.EnumMap;

public class CronParser {
    private final CronType cronType;
    private final com.cronutils.parser.CronParser cronParser;

    public CronParser(CronType cronType) {
        this.cronType = cronType;
        this.cronParser = new com.cronutils.parser.CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)cronType));
    }

    public CronType cronType() {
        return this.cronType;
    }

    public Cron parse(String value) {
        return this.cronParser.parse(value);
    }

    public Cron mapToQuartz(Cron cron) {
        switch (this.cronType) {
            case QUARTZ: {
                return cron;
            }
            case UNIX: {
                return CronMapper.fromUnixToQuartz().map(cron);
            }
            case CRON4J: {
                return CronMapper.fromCron4jToQuartz().map(cron);
            }
            case SPRING: {
                return CronMapper.fromSpringToQuartz().map(cron);
            }
            case SPRING53: {
                return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.SPRING53), CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ), CronParser.setQuestionMark()).map(cron);
            }
        }
        throw new IllegalStateException("Unsupported cron type: " + this.cronType);
    }

    private static Function<Cron, Cron> setQuestionMark() {
        return cron -> {
            CronField dow = cron.retrieve(CronFieldName.DAY_OF_WEEK);
            CronField dom = cron.retrieve(CronFieldName.DAY_OF_MONTH);
            if (dow == null && dom == null) {
                return cron;
            }
            if (dow.getExpression() instanceof QuestionMark || dom.getExpression() instanceof QuestionMark) {
                return cron;
            }
            EnumMap<CronFieldName, CronField> fields = new EnumMap<CronFieldName, CronField>(CronFieldName.class);
            fields.putAll(cron.retrieveFieldsAsMap());
            if (dow.getExpression() instanceof Always) {
                fields.put(CronFieldName.DAY_OF_WEEK, new CronField(CronFieldName.DAY_OF_WEEK, FieldExpression.questionMark(), ((CronField)fields.get(CronFieldName.DAY_OF_WEEK)).getConstraints()));
            } else if (dom.getExpression() instanceof Always) {
                fields.put(CronFieldName.DAY_OF_MONTH, new CronField(CronFieldName.DAY_OF_MONTH, FieldExpression.questionMark(), ((CronField)fields.get(CronFieldName.DAY_OF_MONTH)).getConstraints()));
            } else {
                cron.validate();
            }
            return new SingleCron(cron.getCronDefinition(), new ArrayList(fields.values()));
        };
    }
}

