/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cloud.config.client.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.runtime.ResettableSystemProperties;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.spring.cloud.config.client.runtime.ConfigServerBaseUrlProvider;
import io.quarkus.spring.cloud.config.client.runtime.ConfigServerUrl;
import io.quarkus.spring.cloud.config.client.runtime.DirectConfigServerBaseUrlProvider;
import io.quarkus.spring.cloud.config.client.runtime.DiscoveryConfigServerBaseUrlProvider;
import io.quarkus.spring.cloud.config.client.runtime.Response;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigClientConfig;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigClientGateway;
import io.quarkus.spring.cloud.config.client.runtime.eureka.DiscoveryService;
import io.quarkus.spring.cloud.config.client.runtime.eureka.EurekaClient;
import io.quarkus.spring.cloud.config.client.runtime.eureka.EurekaResponseMapper;
import io.quarkus.spring.cloud.config.client.runtime.eureka.RandomEurekaInstanceSelector;
import io.quarkus.spring.cloud.config.client.runtime.util.UrlUtility;
import io.smallrye.mutiny.Uni;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyStoreOptionsBase;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

public class VertxSpringCloudConfigGateway
implements SpringCloudConfigClientGateway {
    private static final Logger log = Logger.getLogger(VertxSpringCloudConfigGateway.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String PKS_12 = "PKS12";
    private static final String JKS = "JKS";
    private final SpringCloudConfigClientConfig config;
    private final Vertx vertx;
    private final WebClient webClient;
    private final ConfigServerBaseUrlProvider configServerBaseUrlProvider;

    public VertxSpringCloudConfigGateway(SpringCloudConfigClientConfig config) {
        this.config = config;
        this.vertx = this.createVertxInstance();
        this.webClient = VertxSpringCloudConfigGateway.createHttpClient(this.vertx, config);
        this.configServerBaseUrlProvider = this.createConfigServerProvider(config);
    }

    private ConfigServerBaseUrlProvider createConfigServerProvider(SpringCloudConfigClientConfig config) {
        if (!config.discovery().isPresent() || !config.discovery().get().enabled()) {
            return new DirectConfigServerBaseUrlProvider(config);
        }
        DiscoveryService discoveryService = this.createDiscoveryService(config.discovery().get());
        return new DiscoveryConfigServerBaseUrlProvider(discoveryService, config);
    }

    private DiscoveryService createDiscoveryService(SpringCloudConfigClientConfig.DiscoveryConfig config) {
        EurekaClient eurekaClient = this.createEurekaClient(config.eurekaConfig().get());
        return new DiscoveryService(eurekaClient);
    }

    private EurekaClient createEurekaClient(SpringCloudConfigClientConfig.DiscoveryConfig.EurekaConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Eureka configuration is required");
        }
        Duration fetchInterval = config.registryFetchIntervalSeconds();
        EurekaResponseMapper responseMapper = new EurekaResponseMapper();
        RandomEurekaInstanceSelector instanceSelector = new RandomEurekaInstanceSelector();
        return new EurekaClient(this.webClient, fetchInterval, responseMapper, instanceSelector);
    }

    private Vertx createVertxInstance() {
        try (ResettableSystemProperties resettableSystemProperties = ResettableSystemProperties.of((String)"vertx.disableDnsResolver", (String)"true");){
            Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions());
            return vertx;
        }
    }

    public static WebClient createHttpClient(Vertx vertx, SpringCloudConfigClientConfig config) {
        WebClientOptions webClientOptions = new WebClientOptions().setConnectTimeout((int)config.connectionTimeout().toMillis()).setIdleTimeout((int)config.readTimeout().getSeconds());
        try {
            KeyStoreOptionsBase storeOptions;
            String type;
            if (config.trustStore().isPresent()) {
                Path trustStorePath = config.trustStore().get();
                type = VertxSpringCloudConfigGateway.determineStoreType(trustStorePath);
                storeOptions = VertxSpringCloudConfigGateway.storeOptions(trustStorePath, config.trustStorePassword(), VertxSpringCloudConfigGateway.createStoreOptions(type));
                if (VertxSpringCloudConfigGateway.isPfx(type)) {
                    webClientOptions.setPfxTrustOptions((PfxOptions)storeOptions);
                } else {
                    webClientOptions.setTrustStoreOptions((JksOptions)storeOptions);
                }
            } else if (config.trustCerts()) {
                VertxSpringCloudConfigGateway.skipVerify(webClientOptions);
            }
            if (config.keyStore().isPresent()) {
                Path keyStorePath = config.keyStore().get();
                type = VertxSpringCloudConfigGateway.determineStoreType(keyStorePath);
                storeOptions = VertxSpringCloudConfigGateway.storeOptions(keyStorePath, config.keyStorePassword(), VertxSpringCloudConfigGateway.createStoreOptions(type));
                if (VertxSpringCloudConfigGateway.isPfx(type)) {
                    webClientOptions.setPfxKeyCertOptions((PfxOptions)storeOptions);
                } else {
                    webClientOptions.setKeyStoreOptions((JksOptions)storeOptions);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return WebClient.create((Vertx)vertx, (WebClientOptions)webClientOptions);
    }

    private static void skipVerify(WebClientOptions options) {
        options.setTrustAll(true);
        options.setVerifyHost(false);
    }

    private static KeyStoreOptionsBase createStoreOptions(String type) {
        if (VertxSpringCloudConfigGateway.isPfx(type)) {
            return new PfxOptions();
        }
        return new JksOptions();
    }

    private static boolean isPfx(String type) {
        return PKS_12.equals(type);
    }

    private static <T extends KeyStoreOptionsBase> KeyStoreOptionsBase storeOptions(Path storePath, Optional<String> storePassword, T store) throws Exception {
        return store.setPassword(storePassword.orElse("")).setValue(Buffer.buffer((byte[])VertxSpringCloudConfigGateway.storeBytes(storePath)));
    }

    private static String determineStoreType(Path keyStorePath) {
        String pathName = keyStorePath.toString().toLowerCase();
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return PKS_12;
        }
        return JKS;
    }

    private static byte[] storeBytes(Path keyStorePath) throws Exception {
        InputStream classPathResource = Thread.currentThread().getContextClassLoader().getResourceAsStream(ClassPathUtils.toResourceName((Path)keyStorePath));
        if (classPathResource != null) {
            try (InputStream is = classPathResource;){
                byte[] byArray = VertxSpringCloudConfigGateway.allBytes(is);
                return byArray;
            }
        }
        try (InputStream is = Files.newInputStream(keyStorePath, new OpenOption[0]);){
            byte[] byArray = VertxSpringCloudConfigGateway.allBytes(is);
            return byArray;
        }
    }

    private static byte[] allBytes(InputStream inputStream) throws Exception {
        return inputStream.readAllBytes();
    }

    private ConfigServerUrl toConfigServerUrl(String applicationName, String profile) {
        URI baseURI = this.configServerBaseUrlProvider.get();
        String path = baseURI.getPath();
        ArrayList<String> finalPathSegments = new ArrayList<String>();
        finalPathSegments.add(path);
        finalPathSegments.add(applicationName);
        finalPathSegments.add(profile);
        if (this.config.label().isPresent()) {
            finalPathSegments.add(this.config.label().get());
        }
        return new ConfigServerUrl(baseURI, UrlUtility.getPort(baseURI), baseURI.getHost(), String.join((CharSequence)"/", finalPathSegments));
    }

    @Override
    public Uni<Response> exchange(String applicationName, String profile) {
        ConfigServerUrl requestURI = this.toConfigServerUrl(applicationName, profile);
        HttpRequest request = this.webClient.get(requestURI.port(), requestURI.host(), requestURI.completeURLString()).ssl(Boolean.valueOf(UrlUtility.isHttps(requestURI.baseURI()))).putHeader("Accept", "application/json");
        if (this.config.usernameAndPasswordSet()) {
            request.basicAuthentication(this.config.username().get(), this.config.password().get());
        }
        for (Map.Entry<String, String> entry : this.config.headers().entrySet()) {
            request.putHeader(entry.getKey(), entry.getValue());
        }
        log.debug((Object)("Attempting to read configuration from '" + requestURI.completeURLString() + "'."));
        return request.send().map(r -> {
            log.debug((Object)("Received HTTP response code '" + r.statusCode() + "'"));
            if (r.statusCode() != 200) {
                throw new RuntimeException("Got unexpected HTTP response code " + r.statusCode() + " from " + requestURI.completeURLString());
            }
            String bodyAsString = r.bodyAsString();
            if (bodyAsString.isEmpty()) {
                throw new RuntimeException("Got empty HTTP response body " + requestURI.completeURLString());
            }
            try {
                log.debug((Object)"Attempting to deserialize response");
                return (Response)OBJECT_MAPPER.readValue(bodyAsString, Response.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Got unexpected error " + e.getOriginalMessage());
            }
        });
    }

    @Override
    public void close() {
        this.webClient.close();
        this.vertx.closeAndAwait();
    }
}

