package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * Base interface for authorization handlers that provide authorization support.
 * <p>
 * AuthorizationHandlerImpl usually requires a {@link io.vertx.mutiny.ext.web.handler.AuthenticationHandler} to be on the routing chain before it
 * or a custom handler that has previously set a {@link io.vertx.mutiny.ext.auth.User} in the {@link io.vertx.mutiny.ext.web.RoutingContext}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.AuthorizationHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.AuthorizationHandler.class)
public class AuthorizationHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<AuthorizationHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AuthorizationHandler((io.vertx.ext.web.handler.AuthorizationHandler) obj),
    AuthorizationHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.AuthorizationHandler delegate;
  
  public AuthorizationHandler(io.vertx.ext.web.handler.AuthorizationHandler delegate) {
    this.delegate = delegate;
  }

  public AuthorizationHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.AuthorizationHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AuthorizationHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.AuthorizationHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthorizationHandler that = (AuthorizationHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param authorization the authorization to attest.
   * @return fluent self.
   */
  public static io.vertx.mutiny.ext.web.handler.AuthorizationHandler create(io.vertx.mutiny.ext.auth.authorization.Authorization authorization) { 
    io.vertx.mutiny.ext.web.handler.AuthorizationHandler ret = io.vertx.mutiny.ext.web.handler.AuthorizationHandler.newInstance((io.vertx.ext.web.handler.AuthorizationHandler)io.vertx.ext.web.handler.AuthorizationHandler.create(authorization.getDelegate()));
    return ret;
  }

  /**
   * @param authorizationProvider a provider.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.AuthorizationHandler addAuthorizationProvider(io.vertx.mutiny.ext.auth.authorization.AuthorizationProvider authorizationProvider) { 
    delegate.addAuthorizationProvider(authorizationProvider.getDelegate());
    return this;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  AuthorizationHandler newInstance(io.vertx.ext.web.handler.AuthorizationHandler arg) {
    return arg != null ? new AuthorizationHandler(arg) : null;
  }

}
