package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;

/**
 * An auth handler that provides JWT Authentication support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.JWTAuthHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.JWTAuthHandler.class)
public class JWTAuthHandler implements io.vertx.mutiny.ext.web.handler.AuthenticationHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<JWTAuthHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JWTAuthHandler((io.vertx.ext.web.handler.JWTAuthHandler) obj),
    JWTAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.JWTAuthHandler delegate;
  
  public JWTAuthHandler(io.vertx.ext.web.handler.JWTAuthHandler delegate) {
    this.delegate = delegate;
  }

  public JWTAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.JWTAuthHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JWTAuthHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.JWTAuthHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JWTAuthHandler that = (JWTAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static io.vertx.mutiny.ext.web.handler.JWTAuthHandler create(io.vertx.mutiny.ext.auth.jwt.JWTAuth authProvider) { 
    io.vertx.mutiny.ext.web.handler.JWTAuthHandler ret = io.vertx.mutiny.ext.web.handler.JWTAuthHandler.newInstance((io.vertx.ext.web.handler.JWTAuthHandler)io.vertx.ext.web.handler.JWTAuthHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * @param authProvider the auth provider to use
   * @param realm 
   * @return the auth handler
   */
  public static io.vertx.mutiny.ext.web.handler.JWTAuthHandler create(io.vertx.mutiny.ext.auth.jwt.JWTAuth authProvider, String realm) { 
    io.vertx.mutiny.ext.web.handler.JWTAuthHandler ret = io.vertx.mutiny.ext.web.handler.JWTAuthHandler.newInstance((io.vertx.ext.web.handler.JWTAuthHandler)io.vertx.ext.web.handler.JWTAuthHandler.create(authProvider.getDelegate(), realm));
    return ret;
  }

  /**
   * @param delimiter scope delimiter.
   * @return new instance of this interface.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.JWTAuthHandler scopeDelimiter(String delimiter) { 
    delegate.scopeDelimiter(delimiter);
    return this;
  }

  /**
   * @param scope scope.
   * @return new instance of this interface.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.JWTAuthHandler withScope(String scope) { 
    delegate.withScope(scope);
    return this;
  }

  /**
   * @param scopes scopes.
   * @return new instance of this interface.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.JWTAuthHandler withScopes(List<String> scopes) { 
    delegate.withScopes(scopes);
    return this;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  JWTAuthHandler newInstance(io.vertx.ext.web.handler.JWTAuthHandler arg) {
    return arg != null ? new JWTAuthHandler(arg) : null;
  }

}
