/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.lz4;

import io.trino.jdbc.$internal.airlift.compress.v3.Compressor;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4JavaCompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4NativeCompressor;
import java.lang.foreign.MemorySegment;

public sealed interface Lz4Compressor
extends Compressor
permits Lz4JavaCompressor, Lz4NativeCompressor {
    @Override
    public int compress(MemorySegment var1, MemorySegment var2);

    public static Lz4Compressor create() {
        return Lz4Compressor.create(1);
    }

    public static Lz4Compressor create(int acceleration) {
        if (Lz4NativeCompressor.isEnabled()) {
            return new Lz4NativeCompressor(acceleration);
        }
        if (acceleration != 1) {
            throw new IllegalArgumentException("Acceleration different from default cannot be used for non-native LZ4 compression");
        }
        return new Lz4JavaCompressor();
    }
}

