/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.lzo;

import io.trino.jdbc.$internal.airlift.compress.v3.Compressor;
import io.trino.jdbc.$internal.airlift.compress.v3.lzo.LzoRawCompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.lzo.UnsafeUtil;
import java.lang.foreign.MemorySegment;
import java.lang.ref.Reference;
import java.util.Objects;
import sun.misc.Unsafe;

public class LzoCompressor
implements Compressor {
    private final int[] table = new int[4096];

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return LzoRawCompressor.maxCompressedLength(uncompressedSize);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        LzoCompressor.verifyRange(input, inputOffset, inputLength);
        LzoCompressor.verifyRange(output, outputOffset, maxOutputLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        return LzoRawCompressor.compress(input, inputAddress, inputLength, output, outputAddress, maxOutputLength, this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compress(MemorySegment input, MemorySegment output) {
        try {
            int n = LzoRawCompressor.compress(UnsafeUtil.getBase(input), UnsafeUtil.getAddress(input), Math.toIntExact(input.byteSize()), UnsafeUtil.getBase(output), UnsafeUtil.getAddress(output), Math.toIntExact(output.byteSize()), this.table);
            return n;
        }
        finally {
            Reference.reachabilityFence(input);
            Reference.reachabilityFence(output);
        }
    }

    @Override
    public int getRetainedSizeInBytes(int inputLength) {
        return 4096;
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

