/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.airlift.units.DataSize;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

class MaterializingInputStream
extends FilterInputStream {
    private byte[] head;
    private int remaining;
    private int currentOffset;

    protected MaterializingInputStream(InputStream stream, DataSize maxBytes) {
        super(stream);
        this.head = new byte[Math.toIntExact(maxBytes.toBytes())];
    }

    @Override
    public int read() throws IOException {
        int value = super.read();
        if (value != -1) {
            if (this.currentOffset < this.head.length) {
                this.head[this.currentOffset++] = (byte)value;
            } else {
                ++this.remaining;
            }
        }
        return value;
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        int read = super.read(buffer, off, len);
        if (read > 0) {
            int copyLength = Math.min(read, this.head.length - this.currentOffset);
            if (read > copyLength) {
                this.remaining += read - copyLength;
            }
            if (copyLength > 0) {
                System.arraycopy(buffer, off, this.head, this.currentOffset, copyLength);
                this.currentOffset += copyLength;
            }
        }
        return read;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public String getHeadString() {
        return this.getHeadString(StandardCharsets.UTF_8);
    }

    public String getHeadString(Charset charset) {
        if (this.head == null) {
            return "<empty>";
        }
        CharsetDecoder charsetDecoder = MoreObjects.firstNonNull(charset, StandardCharsets.UTF_8).newDecoder().onMalformedInput(CodingErrorAction.IGNORE).onUnmappableCharacter(CodingErrorAction.IGNORE);
        try {
            return String.valueOf(charsetDecoder.decode(ByteBuffer.wrap(this.head, 0, this.currentOffset))) + (this.remaining > 0 ? String.format("... [" + this.bytesOmitted(this.remaining) + "]", this.remaining) : "");
        }
        catch (CharacterCodingException e) {
            return String.format("<error:%s>", e.getMessage());
        }
    }

    private String bytesOmitted(long bytes) {
        if (bytes == 1L) {
            return "1 more byte";
        }
        return String.format("%d more bytes", bytes);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.head = null;
    }
}

