/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.PemReader;
import io.trino.jdbc.$internal.client.auth.kerberos.DelegatedConstrainedContextProvider;
import io.trino.jdbc.$internal.client.auth.kerberos.DelegatedUnconstrainedContextProvider;
import io.trino.jdbc.$internal.client.auth.kerberos.GSSContextProvider;
import io.trino.jdbc.$internal.client.auth.kerberos.LoginBasedUnconstrainedContextProvider;
import io.trino.jdbc.$internal.client.auth.kerberos.SpnegoHandler;
import io.trino.jdbc.$internal.client.uri.LoggingLevel;
import io.trino.jdbc.$internal.guava.base.CharMatcher;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.base.StandardSystemProperty;
import io.trino.jdbc.$internal.guava.net.HostAndPort;
import io.trino.jdbc.$internal.okhttp3.Credentials;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.JavaNetCookieJar;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import io.trino.jdbc.$internal.okhttp3.internal.tls.LegacyHostnameVerifier;
import io.trino.jdbc.$internal.okhttp3.logging.HttpLoggingInterceptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieManager;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.ietf.jgss.GSSCredential;

public final class OkHttpUtil {
    private static final String KEYSTORE_MACOS = "KeychainStore";
    private static final String KEYSTORE_WINDOWS_MY = "Windows-MY-CURRENTUSER";
    private static final String KEYSTORE_WINDOWS_ROOT = "Windows-ROOT-CURRENTUSER";

    private OkHttpUtil() {
    }

    public static Interceptor userAgent(String userAgent) {
        return chain -> chain.proceed(chain.request().newBuilder().header("User-Agent", userAgent).build());
    }

    public static Interceptor basicAuth(String user, String password) {
        Objects.requireNonNull(user, "user is null");
        Objects.requireNonNull(password, "password is null");
        if (user.contains(":")) {
            throw new ClientException("Illegal character ':' found in username");
        }
        String credential = Credentials.basic(user, password);
        return chain -> chain.proceed(chain.request().newBuilder().header("Authorization", credential).build());
    }

    public static Interceptor tokenAuth(String accessToken) {
        Objects.requireNonNull(accessToken, "accessToken is null");
        Preconditions.checkArgument(CharMatcher.inRange('!', '~').matchesAllOf(accessToken));
        return chain -> chain.proceed(chain.request().newBuilder().addHeader("Authorization", "Bearer " + accessToken).build());
    }

    public static void setupTimeouts(OkHttpClient.Builder clientBuilder, int timeout2, TimeUnit unit) {
        clientBuilder.connectTimeout(timeout2, unit).readTimeout(timeout2, unit).writeTimeout(timeout2, unit);
    }

    public static void setupCookieJar(OkHttpClient.Builder clientBuilder) {
        clientBuilder.cookieJar(new JavaNetCookieJar(new CookieManager()));
    }

    public static void setupSocksProxy(OkHttpClient.Builder clientBuilder, Optional<HostAndPort> socksProxy) {
        OkHttpUtil.setupProxy(clientBuilder, socksProxy, Proxy.Type.SOCKS);
    }

    public static void setupHttpProxy(OkHttpClient.Builder clientBuilder, Optional<HostAndPort> httpProxy) {
        OkHttpUtil.setupProxy(clientBuilder, httpProxy, Proxy.Type.HTTP);
    }

    public static void setupProxy(OkHttpClient.Builder clientBuilder, Optional<HostAndPort> proxy, Proxy.Type type) {
        proxy.map(OkHttpUtil::toUnresolvedAddress).map(address -> new Proxy(type, (SocketAddress)address)).ifPresent(clientBuilder::proxy);
    }

    public static void setupHttpLogging(OkHttpClient.Builder clientBuilder, LoggingLevel level) {
        switch (level) {
            case NONE: {
                return;
            }
            case BODY: {
                clientBuilder.addNetworkInterceptor(new HttpLoggingInterceptor(System.err::println).setLevel(HttpLoggingInterceptor.Level.BODY));
                break;
            }
            case BASIC: {
                clientBuilder.addNetworkInterceptor(new HttpLoggingInterceptor(System.err::println).setLevel(HttpLoggingInterceptor.Level.BASIC));
                break;
            }
            case HEADERS: {
                clientBuilder.addNetworkInterceptor(new HttpLoggingInterceptor(System.err::println).setLevel(HttpLoggingInterceptor.Level.HEADERS));
            }
        }
    }

    private static InetSocketAddress toUnresolvedAddress(HostAndPort address) {
        return InetSocketAddress.createUnresolved(address.getHost(), address.getPort());
    }

    public static void setupInsecureSsl(OkHttpClient.Builder clientBuilder) {
        try {
            X509TrustManager trustAllCerts = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    throw new UnsupportedOperationException("checkClientTrusted should not be called");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustAllCerts}, new SecureRandom());
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustAllCerts);
            clientBuilder.hostnameVerifier((hostname, session) -> true);
        }
        catch (GeneralSecurityException e) {
            throw new ClientException("Error setting up SSL: " + e.getMessage(), e);
        }
    }

    public static void setupSsl(OkHttpClient.Builder clientBuilder, Optional<String> keyStorePath, Optional<String> keyStorePassword, Optional<String> keyStoreType, boolean useSystemKeyStore, Optional<String> trustStorePath, Optional<String> trustStorePassword, Optional<String> trustStoreType, boolean useSystemTrustStore) {
        if (!(keyStorePath.isPresent() || useSystemKeyStore || trustStorePath.isPresent() || useSystemTrustStore)) {
            return;
        }
        try {
            KeyStore keyStore = null;
            KeyManager[] keyManagers = null;
            char[] keyManagerPassword = null;
            if (useSystemKeyStore) {
                keyStore = OkHttpUtil.loadSystemKeyStore(keyStoreType);
            } else if (keyStorePath.isPresent()) {
                try {
                    keyStore = PemReader.loadKeyStore(new File(keyStorePath.get()), new File(keyStorePath.get()), keyStorePassword);
                    keyManagerPassword = new char[]{};
                }
                catch (IOException | GeneralSecurityException ignored) {
                    keyManagerPassword = keyStorePassword.map(String::toCharArray).orElse(null);
                    keyStore = KeyStore.getInstance(keyStoreType.orElseGet(KeyStore::getDefaultType));
                    try (FileInputStream in = new FileInputStream(keyStorePath.get());){
                        keyStore.load(in, keyManagerPassword);
                    }
                }
                OkHttpUtil.validateCertificates(keyStore);
            }
            if (keyStore != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, keyManagerPassword);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            KeyStore trustStore = keyStore;
            if (useSystemTrustStore) {
                trustStore = OkHttpUtil.loadSystemTrustStore(trustStoreType);
            } else if (trustStorePath.isPresent()) {
                trustStore = OkHttpUtil.loadTrustStore(new File(trustStorePath.get()), trustStorePassword, trustStoreType);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new RuntimeException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            clientBuilder.hostnameVerifier(LegacyHostnameVerifier.INSTANCE);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ClientException("Error setting up SSL: " + e.getMessage(), e);
        }
    }

    private static void validateCertificates(KeyStore keyStore) throws GeneralSecurityException {
        for (String alias : Collections.list(keyStore.aliases())) {
            Certificate certificate;
            if (!keyStore.isKeyEntry(alias) || !((certificate = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            try {
                ((X509Certificate)certificate).checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new CertificateExpiredException("KeyStore certificate is expired: " + e.getMessage());
            }
            catch (CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException("KeyStore certificate is not yet valid: " + e.getMessage());
            }
        }
    }

    private static KeyStore loadTrustStore(File trustStorePath, Optional<String> trustStorePassword, Optional<String> trustStoreType) throws IOException, GeneralSecurityException {
        KeyStore trustStore = KeyStore.getInstance(trustStoreType.orElseGet(KeyStore::getDefaultType));
        try {
            List<X509Certificate> certificateChain = PemReader.readCertificateChain(trustStorePath);
            if (!certificateChain.isEmpty()) {
                trustStore.load(null, null);
                for (X509Certificate certificate : certificateChain) {
                    X500Principal principal = certificate.getSubjectX500Principal();
                    trustStore.setCertificateEntry(principal.getName(), certificate);
                }
                return trustStore;
            }
        }
        catch (IOException | GeneralSecurityException certificateChain) {
            // empty catch block
        }
        try (InputStream in = Files.newInputStream(trustStorePath.toPath(), new OpenOption[0]);){
            trustStore.load(in, trustStorePassword.map(String::toCharArray).orElse(null));
        }
        return trustStore;
    }

    private static KeyStore loadSystemKeyStore(Optional<String> keyStoreType) throws IOException, GeneralSecurityException {
        return OkHttpUtil.loadSystemStore(keyStoreType, KEYSTORE_MACOS, KEYSTORE_WINDOWS_MY);
    }

    private static KeyStore loadSystemTrustStore(Optional<String> trustStoreType) throws IOException, GeneralSecurityException {
        return OkHttpUtil.loadSystemStore(trustStoreType, KEYSTORE_MACOS, KEYSTORE_WINDOWS_ROOT);
    }

    private static KeyStore loadSystemStore(Optional<String> storeType, String mac, String windows) throws IOException, GeneralSecurityException {
        String osName = Optional.ofNullable(StandardSystemProperty.OS_NAME.value()).orElse("");
        Optional<String> systemStoreType = storeType;
        if (!systemStoreType.isPresent()) {
            if (osName.contains("Windows")) {
                systemStoreType = Optional.of(windows);
            } else if (osName.contains("Mac")) {
                systemStoreType = Optional.of(mac);
            }
        }
        KeyStore store = KeyStore.getInstance(systemStoreType.orElseGet(KeyStore::getDefaultType));
        store.load(null, null);
        return store;
    }

    public static void setupKerberos(OkHttpClient.Builder clientBuilder, String servicePrincipalPattern, String remoteServiceName, boolean useCanonicalHostname, Optional<String> principal, Optional<File> kerberosConfig, Optional<File> keytab, Optional<File> credentialCache, boolean delegatedKerberos, Optional<GSSCredential> gssCredential) {
        GSSContextProvider contextProvider = delegatedKerberos ? OkHttpUtil.getDelegatedGSSContextProvider(gssCredential) : new LoginBasedUnconstrainedContextProvider(principal, kerberosConfig, keytab, credentialCache);
        SpnegoHandler handler = new SpnegoHandler(servicePrincipalPattern, remoteServiceName, useCanonicalHostname, contextProvider);
        clientBuilder.addInterceptor(handler);
        clientBuilder.authenticator(handler);
    }

    public static void setupAlternateHostnameVerification(OkHttpClient.Builder clientBuilder, String alternativeHostname) {
        clientBuilder.hostnameVerifier((hostname, session) -> LegacyHostnameVerifier.INSTANCE.verify(alternativeHostname, session));
    }

    private static GSSContextProvider getDelegatedGSSContextProvider(Optional<GSSCredential> gssCredential) {
        return gssCredential.map(DelegatedConstrainedContextProvider::new).map(gssCred -> gssCred).orElse(new DelegatedUnconstrainedContextProvider());
    }
}

