/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.CloseableIterator;
import io.trino.jdbc.$internal.client.Column;
import io.trino.jdbc.$internal.client.JsonIterators;
import io.trino.jdbc.$internal.client.JsonQueryData;
import io.trino.jdbc.$internal.client.OkHttpSegmentLoader;
import io.trino.jdbc.$internal.client.QueryData;
import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.QueryResults;
import io.trino.jdbc.$internal.client.ResultRows;
import io.trino.jdbc.$internal.client.TypedQueryData;
import io.trino.jdbc.$internal.client.spooling.DataAttributes;
import io.trino.jdbc.$internal.client.spooling.EncodedQueryData;
import io.trino.jdbc.$internal.client.spooling.SegmentLoader;
import io.trino.jdbc.$internal.client.spooling.SegmentsIterator;
import io.trino.jdbc.$internal.client.spooling.encoding.QueryDataDecoders;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.base.Verify;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ResultRowsDecoder
implements AutoCloseable {
    private final SegmentLoader loader;
    private QueryDataDecoder decoder;

    public ResultRowsDecoder() {
        this(new OkHttpSegmentLoader());
    }

    public ResultRowsDecoder(SegmentLoader loader) {
        this.loader = Objects.requireNonNull(loader, "loader is null");
    }

    private void setEncoding(List<Column> columns, String encoding) {
        if (this.decoder != null) {
            Preconditions.checkState(this.decoder.encoding().equals(encoding), "Decoder is configured for encoding %s but got %s", (Object)this.decoder.encoding(), (Object)encoding);
        } else {
            Preconditions.checkState(!columns.isEmpty(), "Columns must be set when decoding data");
            this.decoder = QueryDataDecoders.get(encoding).create(columns, DataAttributes.empty());
        }
    }

    public ResultRows toRows(QueryResults results) {
        if (results == null || results.getData() == null || results.getData().isNull()) {
            return ResultRows.NULL_ROWS;
        }
        return this.toRows(results.getColumns(), results.getData());
    }

    public ResultRows toRows(List<Column> columns, QueryData data) {
        if (data == null || data.isNull()) {
            return ResultRows.NULL_ROWS;
        }
        Verify.verify(columns != null && !columns.isEmpty(), "Columns must be set when decoding data", new Object[0]);
        if (data instanceof TypedQueryData) {
            TypedQueryData rawData = (TypedQueryData)data;
            return ResultRows.wrapIterator(CloseableIterator.closeable(rawData.getIterable().iterator()), rawData.getRowsCount());
        }
        if (data instanceof JsonQueryData) {
            JsonQueryData jsonData = (JsonQueryData)data;
            try {
                return ResultRows.wrapIterator(JsonIterators.forJsonParser(jsonData.getJsonParser(), columns), jsonData.getRowsCount());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (data instanceof EncodedQueryData) {
            EncodedQueryData encodedData = (EncodedQueryData)data;
            this.setEncoding(columns, encodedData.getEncoding());
            return ResultRows.wrapIterator(new SegmentsIterator(this.loader, this.decoder, encodedData.getSegments()), encodedData.getRowsCount());
        }
        throw new UnsupportedOperationException("Unsupported data type: " + data.getClass().getName());
    }

    public Optional<String> getEncoding() {
        return Optional.ofNullable(this.decoder).map(QueryDataDecoder::encoding);
    }

    @Override
    public void close() throws Exception {
        this.loader.close();
    }
}

