/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.encoding.CompressedQueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.encoding.DecompressionUtils;
import java.io.IOException;

public class ZstdQueryDataDecoder
extends CompressedQueryDataDecoder {
    public ZstdQueryDataDecoder(QueryDataDecoder delegate) {
        super(delegate);
    }

    @Override
    void decompress(byte[] bytes, byte[] output) throws IOException {
        int decompressedSize = DecompressionUtils.decompressZstd(bytes, output);
        if (decompressedSize != output.length) {
            throw new IOException(String.format("Decompressed size does not match expected segment size, expected %d, got %d", decompressedSize, output.length));
        }
    }

    @Override
    public String encoding() {
        return this.delegate.encoding() + "+zstd";
    }
}

