/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.jackson.datatype.jdk8;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.jackson.databind.DeserializationConfig;
import io.trino.jdbc.$internal.jackson.databind.JavaType;
import io.trino.jdbc.$internal.jackson.databind.JsonDeserializer;
import io.trino.jdbc.$internal.jackson.databind.JsonMappingException;
import io.trino.jdbc.$internal.jackson.databind.deser.Deserializers;
import io.trino.jdbc.$internal.jackson.databind.type.ReferenceType;
import io.trino.jdbc.$internal.jackson.datatype.jdk8.OptionalDeserializer;
import io.trino.jdbc.$internal.jackson.datatype.jdk8.OptionalDoubleDeserializer;
import io.trino.jdbc.$internal.jackson.datatype.jdk8.OptionalIntDeserializer;
import io.trino.jdbc.$internal.jackson.datatype.jdk8.OptionalLongDeserializer;
import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class Jdk8Deserializers
extends Deserializers.Base
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final boolean _cfgReadAbsentAsNull;

    public Jdk8Deserializers() {
        this(false);
    }

    public Jdk8Deserializers(boolean cfgReadAbsentAsNull) {
        this._cfgReadAbsentAsNull = cfgReadAbsentAsNull;
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, .BeanDescription beanDesc, .TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) {
        if (refType.hasRawClass(Optional.class)) {
            return new OptionalDeserializer(refType, null, contentTypeDeserializer, contentDeserializer, this._cfgReadAbsentAsNull);
        }
        if (refType.hasRawClass(OptionalInt.class)) {
            return OptionalIntDeserializer.INSTANCE;
        }
        if (refType.hasRawClass(OptionalLong.class)) {
            return OptionalLongDeserializer.INSTANCE;
        }
        if (refType.hasRawClass(OptionalDouble.class)) {
            return OptionalDoubleDeserializer.INSTANCE;
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, .BeanDescription beanDesc) throws JsonMappingException {
        if (type.hasRawClass(Optional.class)) {
            JavaType refType = config.constructType(Optional.class);
            return new OptionalDeserializer(refType, null, null, null, this._cfgReadAbsentAsNull);
        }
        return null;
    }
}

