/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.okhttp3.internal.concurrent;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.kotlin.jvm.functions.Function0;
import io.trino.jdbc.$internal.kotlin.jvm.internal.InlineMarker;
import io.trino.jdbc.$internal.kotlin.jvm.internal.Intrinsics;
import io.trino.jdbc.$internal.okhttp3.internal.concurrent.Task;
import io.trino.jdbc.$internal.okhttp3.internal.concurrent.TaskQueue;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

@.Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0000\u001a.\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0080\b\u00f8\u0001\u0000\u001a9\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a$\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\tH\u0002\u001a\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"taskLog", "", "Ljava/util/logging/Logger;", "task", "Lio/trino/jdbc/$internal/okhttp3/internal/concurrent/Task;", "queue", "Lio/trino/jdbc/$internal/okhttp3/internal/concurrent/TaskQueue;", "messageBlock", "Lio/trino/jdbc/$internal/kotlin/Function0;", "", "logElapsed", "T", "block", "(Ljava/util/logging/Logger;Lokhttp3/internal/concurrent/Task;Lokhttp3/internal/concurrent/TaskQueue;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "log", "message", "formatDuration", "ns", "", "okhttp"})
public final class TaskLoggerKt {
    public static final void taskLog(@NotNull Logger $this$taskLog, @NotNull Task task, @NotNull TaskQueue queue, @NotNull Function0<String> messageBlock) {
        Intrinsics.checkNotNullParameter($this$taskLog, "<this>");
        Intrinsics.checkNotNullParameter(task, "task");
        Intrinsics.checkNotNullParameter(queue, "queue");
        Intrinsics.checkNotNullParameter(messageBlock, "messageBlock");
        boolean $i$f$taskLog = false;
        if ($this$taskLog.isLoggable(Level.FINE)) {
            TaskLoggerKt.log($this$taskLog, task, queue, messageBlock.invoke());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T logElapsed(@NotNull Logger $this$logElapsed, @NotNull Task task, @NotNull TaskQueue queue, @NotNull Function0<? extends T> block) {
        T t;
        Intrinsics.checkNotNullParameter($this$logElapsed, "<this>");
        Intrinsics.checkNotNullParameter(task, "task");
        Intrinsics.checkNotNullParameter(queue, "queue");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$logElapsed = false;
        long startNs = -1L;
        boolean loggingEnabled = $this$logElapsed.isLoggable(Level.FINE);
        if (loggingEnabled) {
            startNs = queue.getTaskRunner$okhttp().getBackend().nanoTime();
            TaskLoggerKt.log($this$logElapsed, task, queue, "starting");
        }
        boolean completedNormally = false;
        try {
            T result = block.invoke();
            completedNormally = true;
            t = result;
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart(1);
            if (loggingEnabled) {
                long elapsedNs = queue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs;
                if (completedNormally) {
                    TaskLoggerKt.log($this$logElapsed, task, queue, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs));
                } else {
                    TaskLoggerKt.log($this$logElapsed, task, queue, "failed a run in " + TaskLoggerKt.formatDuration(elapsedNs));
                }
            }
            InlineMarker.finallyEnd(1);
            throw throwable;
        }
        InlineMarker.finallyStart(1);
        if (loggingEnabled) {
            long elapsedNs = queue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs;
            TaskLoggerKt.log($this$logElapsed, task, queue, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs));
        }
        InlineMarker.finallyEnd(1);
        return t;
    }

    private static final void log(Logger $this$log, Task task, TaskQueue queue, String message) {
        StringBuilder stringBuilder = new StringBuilder().append(queue.getName$okhttp()).append(' ');
        String string = "%-22s";
        Object[] objectArray = new Object[]{message};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        $this$log.fine(stringBuilder.append(string2).append(": ").append(task.getName()).toString());
    }

    @NotNull
    public static final String formatDuration(long ns) {
        String s = ns <= -999500000L ? (ns - (long)500000000) / (long)1000000000 + " s " : (ns <= -999500L ? (ns - (long)500000) / (long)1000000 + " ms" : (ns <= 0L ? (ns - (long)500) / (long)1000 + " \u00b5s" : (ns < 999500L ? (ns + (long)500) / (long)1000 + " \u00b5s" : (ns < 999500000L ? (ns + (long)500000) / (long)1000000 + " ms" : (ns + (long)500000000) / (long)1000000000 + " s "))));
        String string = "%6s";
        Object[] objectArray = new Object[]{s};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }
}

