/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.okhttp.v3_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.trino.jdbc.$internal.okhttp3.Call;
import io.trino.jdbc.$internal.okhttp3.Callback;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.okio.Timeout;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

class TracingCallFactory
implements Call.Factory {
    private static final VirtualField<Request, Context> contextsByRequest = VirtualField.find(Request.class, Context.class);
    @Nullable
    private static Method timeoutMethod;
    @Nullable
    private static Method cloneMethod;
    private final OkHttpClient okHttpClient;

    TracingCallFactory(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Nullable
    static Context getCallingContextForRequest(Request request) {
        return (Context)contextsByRequest.get((Object)request);
    }

    @Override
    public Call newCall(Request request) {
        Context callingContext = Context.current();
        Request requestCopy = request.newBuilder().build();
        contextsByRequest.set((Object)requestCopy, (Object)callingContext);
        return new TracingCall(this.okHttpClient.newCall(requestCopy), callingContext);
    }

    static {
        try {
            timeoutMethod = Call.class.getMethod("timeout", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            timeoutMethod = null;
        }
        try {
            cloneMethod = Call.class.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            cloneMethod = null;
        }
    }

    static class TracingCall
    implements Call {
        private final Call delegate;
        private final Context callingContext;

        TracingCall(Call delegate, Context callingContext) {
            this.delegate = delegate;
            this.callingContext = callingContext;
        }

        @Override
        public void cancel() {
            this.delegate.cancel();
        }

        @Override
        public Call clone() throws CloneNotSupportedException {
            if (cloneMethod == null) {
                return (Call)super.clone();
            }
            try {
                return new TracingCall((Call)cloneMethod.invoke((Object)this.delegate, new Object[0]), Context.current());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return (Call)super.clone();
            }
        }

        @Override
        public void enqueue(Callback callback) {
            this.delegate.enqueue(new TracingCallback(callback, this.callingContext));
        }

        @Override
        public Response execute() throws IOException {
            try (Scope scope = this.callingContext.makeCurrent();){
                Response response = this.delegate.execute();
                return response;
            }
        }

        @Override
        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        @Override
        public boolean isExecuted() {
            return this.delegate.isExecuted();
        }

        @Override
        public Request request() {
            return this.delegate.request();
        }

        @Override
        public Timeout timeout() {
            if (timeoutMethod == null) {
                return Timeout.NONE;
            }
            try {
                return (Timeout)timeoutMethod.invoke((Object)this.delegate, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return Timeout.NONE;
            }
        }

        private static class TracingCallback
        implements Callback {
            private final Callback delegate;
            private final Context callingContext;

            TracingCallback(Callback delegate, Context callingContext) {
                this.delegate = delegate;
                this.callingContext = callingContext;
            }

            @Override
            public void onFailure(Call call, IOException e) {
                try (Scope scope = this.callingContext.makeCurrent();){
                    this.delegate.onFailure(call, e);
                }
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                try (Scope scope = this.callingContext.makeCurrent();){
                    this.delegate.onResponse(call, response);
                }
            }
        }
    }
}

