/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanBigList;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanBigListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.booleans.BooleanBigList;
import it.unimi.dsi.fastutil.booleans.BooleanBigListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanBigArrayBigList
extends AbstractBooleanBigList
implements RandomAccess,
Cloneable,
Serializable {
    public static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final long ONEOVERPHI = 106039L;
    protected transient boolean[][] a;
    protected long size;
    private static final boolean ASSERTS = false;

    protected BooleanBigArrayBigList(boolean[][] a, boolean dummy) {
        this.a = a;
    }

    public BooleanBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = BooleanBigArrays.newBigArray(capacity);
    }

    public BooleanBigArrayBigList() {
        this(16L);
    }

    public BooleanBigArrayBigList(BooleanCollection c) {
        this(c.size());
        BooleanIterator i = c.iterator();
        while (i.hasNext()) {
            this.add(i.nextBoolean());
        }
    }

    public BooleanBigArrayBigList(BooleanBigList l) {
        this(l.size64());
        this.size = l.size64();
        l.getElements(0L, this.a, 0L, this.size);
    }

    public BooleanBigArrayBigList(boolean[][] a) {
        this(a, 0L, BooleanBigArrays.length(a));
    }

    public BooleanBigArrayBigList(boolean[][] a, long offset, long length) {
        this(length);
        BooleanBigArrays.copy(a, offset, this.a, 0L, length);
        this.size = length;
    }

    public BooleanBigArrayBigList(Iterator<? extends Boolean> i) {
        this();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public BooleanBigArrayBigList(BooleanIterator i) {
        this();
        while (i.hasNext()) {
            this.add(i.nextBoolean());
        }
    }

    public boolean[][] elements() {
        return this.a;
    }

    public static BooleanBigArrayBigList wrap(boolean[][] a, long length) {
        if (length > BooleanBigArrays.length(a)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + BooleanBigArrays.length(a) + ")");
        }
        BooleanBigArrayBigList l = new BooleanBigArrayBigList(a, false);
        l.size = length;
        return l;
    }

    public static BooleanBigArrayBigList wrap(boolean[][] a) {
        return BooleanBigArrayBigList.wrap(a, BooleanBigArrays.length(a));
    }

    public void ensureCapacity(long capacity) {
        this.a = BooleanBigArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(long capacity) {
        this.a = BooleanBigArrays.grow(this.a, capacity, this.size);
    }

    @Override
    public void add(long index, boolean k) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            BooleanBigArrays.copy(this.a, index, this.a, index + 1L, this.size - index);
        }
        BooleanBigArrays.set(this.a, index, k);
        ++this.size;
    }

    @Override
    public boolean add(boolean k) {
        this.grow(this.size + 1L);
        BooleanBigArrays.set(this.a, this.size++, k);
        return true;
    }

    @Override
    public boolean getBoolean(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return BooleanBigArrays.get(this.a, index);
    }

    @Override
    public long indexOf(boolean k) {
        for (long i = 0L; i < this.size; ++i) {
            if (k != BooleanBigArrays.get(this.a, i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(boolean k) {
        long i = this.size;
        while (i-- != 0L) {
            if (k != BooleanBigArrays.get(this.a, i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public boolean removeBoolean(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        boolean old = BooleanBigArrays.get(this.a, index);
        --this.size;
        if (index != this.size) {
            BooleanBigArrays.copy(this.a, index + 1L, this.a, index, this.size - index);
        }
        return old;
    }

    @Override
    public boolean rem(boolean k) {
        long index = this.indexOf(k);
        if (index == -1L) {
            return false;
        }
        this.removeBoolean(index);
        return true;
    }

    @Override
    public boolean set(long index, boolean k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        boolean old = BooleanBigArrays.get(this.a, index);
        BooleanBigArrays.set(this.a, index, k);
        return old;
    }

    @Override
    public void clear() {
        this.size = 0L;
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > BooleanBigArrays.length(this.a)) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            BooleanBigArrays.fill(this.a, this.size, size, false);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n) {
        long arrayLength = BooleanBigArrays.length(this.a);
        if (n >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = BooleanBigArrays.trim(this.a, Math.max(n, this.size));
    }

    public void getElements(int from, boolean[][] a, long offset, long length) {
        BooleanBigArrays.copy(this.a, from, a, offset, length);
    }

    public void removeElements(int from, int to) {
        BigArrays.ensureFromTo(this.size, from, to);
        BooleanBigArrays.copy(this.a, to, this.a, from, this.size - (long)to);
        this.size -= (long)(to - from);
    }

    public void addElements(int index, boolean[][] a, long offset, long length) {
        this.ensureIndex(index);
        BooleanBigArrays.ensureOffsetLength(a, offset, length);
        this.grow(this.size + length);
        BooleanBigArrays.copy(this.a, index, this.a, (long)index + length, this.size - (long)index);
        BooleanBigArrays.copy(a, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public BooleanBigListIterator listIterator(final int index) {
        this.ensureIndex(index);
        return new AbstractBooleanBigListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return (long)this.pos < BooleanBigArrayBigList.this.size;
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public boolean nextBoolean() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return BooleanBigArrays.get(BooleanBigArrayBigList.this.a, this.last);
            }

            public boolean previousBoolean() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return BooleanBigArrays.get(BooleanBigArrayBigList.this.a, this.pos);
            }

            public long nextIndex() {
                return this.pos;
            }

            public long previousIndex() {
                return this.pos - 1;
            }

            public void add(boolean k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                BooleanBigArrayBigList.this.add((long)this.pos++, k);
                this.last = -1;
            }

            public void set(boolean k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                BooleanBigArrayBigList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                BooleanBigArrayBigList.this.removeBoolean(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public BooleanBigArrayBigList clone() {
        BooleanBigArrayBigList c = new BooleanBigArrayBigList(this.size);
        BooleanBigArrays.copy(this.a, 0L, c.a, 0L, this.size);
        c.size = this.size;
        return c;
    }

    public boolean equals(BooleanBigArrayBigList l) {
        if (l == this) {
            return true;
        }
        long s = this.size64();
        if (s != l.size64()) {
            return false;
        }
        boolean[][] a1 = this.a;
        boolean[][] a2 = l.a;
        while (s-- != 0L) {
            if (BooleanBigArrays.get(a1, s) == BooleanBigArrays.get(a2, s)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(BooleanBigArrayBigList l) {
        long s1 = this.size64();
        long s2 = l.size64();
        boolean[][] a1 = this.a;
        boolean[][] a2 = l.a;
        int i = 0;
        while ((long)i < s1 && (long)i < s2) {
            int r;
            boolean e1 = BooleanBigArrays.get(a1, i);
            boolean e2 = BooleanBigArrays.get(a2, i);
            if ((!e1 && e2 ? -1 : (r = e1 == e2 ? 0 : 1)) != 0) {
                return r;
            }
            ++i;
        }
        return (long)i < s2 ? -1 : ((long)i < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int i = 0;
        while ((long)i < this.size) {
            s.writeBoolean(BooleanBigArrays.get(this.a, i));
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = BooleanBigArrays.newBigArray(this.size);
        int i = 0;
        while ((long)i < this.size) {
            BooleanBigArrays.set(this.a, i, s.readBoolean());
            ++i;
        }
    }
}

