/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntOpenHashBigSet
extends AbstractIntSet
implements Serializable,
Cloneable,
Hash,
Size64 {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient int[][] key;
    protected transient boolean[][] used;
    protected final float f;
    protected transient long n;
    protected transient long maxFill;
    protected transient long mask;
    protected transient int segmentMask;
    protected transient int baseMask;
    protected long size;

    private void initMasks() {
        this.mask = this.n - 1L;
        this.segmentMask = this.key[0].length - 1;
        this.baseMask = this.key.length - 1;
    }

    public IntOpenHashBigSet(long expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (this.n < 0L) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.bigArraySize(expected, f);
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = IntBigArrays.newBigArray(this.n);
        this.used = BooleanBigArrays.newBigArray(this.n);
        this.initMasks();
    }

    public IntOpenHashBigSet(long expected) {
        this(expected, 0.75f);
    }

    public IntOpenHashBigSet() {
        this(16L, 0.75f);
    }

    public IntOpenHashBigSet(Collection<? extends Integer> c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public IntOpenHashBigSet(Collection<? extends Integer> c) {
        this(c, 0.75f);
    }

    public IntOpenHashBigSet(IntCollection c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public IntOpenHashBigSet(IntCollection c) {
        this(c, 0.75f);
    }

    public IntOpenHashBigSet(IntIterator i, float f) {
        this(16L, f);
        while (i.hasNext()) {
            this.add(i.nextInt());
        }
    }

    public IntOpenHashBigSet(IntIterator i) {
        this(i, 0.75f);
    }

    public IntOpenHashBigSet(Iterator<?> i, float f) {
        this(IntIterators.asIntIterator(i), f);
    }

    public IntOpenHashBigSet(Iterator<?> i) {
        this(IntIterators.asIntIterator(i));
    }

    public IntOpenHashBigSet(int[] a, int offset, int length, float f) {
        this(length < 0 ? 0L : (long)length, f);
        IntArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public IntOpenHashBigSet(int[] a, int offset, int length) {
        this(a, offset, length, 0.75f);
    }

    public IntOpenHashBigSet(int[] a, float f) {
        this(a, 0, a.length, f);
    }

    public IntOpenHashBigSet(int[] a) {
        this(a, 0.75f);
    }

    @Override
    public boolean add(int k) {
        long h = HashCommon.murmurHash3((long)k);
        int displ = (int)(h & (long)this.segmentMask);
        int base = (int)((h & this.mask) >>> 27);
        while (this.used[base][displ]) {
            if (k == this.key[base][displ]) {
                return false;
            }
            base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
        }
        this.used[base][displ] = true;
        this.key[base][displ] = k;
        if (++this.size >= this.maxFill) {
            this.rehash(2L * this.n);
        }
        return true;
    }

    protected final void shiftKeys(long pos) {
        long last;
        while (true) {
            last = pos;
            pos = last + 1L & this.mask;
            while (BooleanBigArrays.get(this.used, pos)) {
                long slot = HashCommon.murmurHash3((long)IntBigArrays.get(this.key, pos)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1L & this.mask;
            }
            if (!BooleanBigArrays.get(this.used, pos)) break;
            IntBigArrays.set(this.key, last, IntBigArrays.get(this.key, pos));
        }
        BooleanBigArrays.set(this.used, last, false);
    }

    @Override
    public boolean remove(int k) {
        long h = HashCommon.murmurHash3((long)k);
        int displ = (int)(h & (long)this.segmentMask);
        int base = (int)((h & this.mask) >>> 27);
        while (this.used[base][displ]) {
            if (k == this.key[base][displ]) {
                --this.size;
                this.shiftKeys((long)base * 0x8000000L + (long)displ);
                return true;
            }
            base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
        }
        return false;
    }

    @Override
    public boolean contains(int k) {
        long h = HashCommon.murmurHash3((long)k);
        int displ = (int)(h & (long)this.segmentMask);
        int base = (int)((h & this.mask) >>> 27);
        while (this.used[base][displ]) {
            if (k == this.key[base][displ]) {
                return true;
            }
            base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0L) {
            return;
        }
        this.size = 0L;
        BooleanBigArrays.fill(this.used, false);
    }

    @Override
    public IntIterator iterator() {
        return new SetIterator();
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        long l = HashCommon.bigArraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(long n) {
        long l = HashCommon.bigArraySize(n, this.f);
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(long newN) {
        boolean[][] used = this.used;
        int[][] key = this.key;
        boolean[][] newUsed = BooleanBigArrays.newBigArray(newN);
        int[][] newKey = IntBigArrays.newBigArray(newN);
        long newMask = newN - 1L;
        int newSegmentMask = newKey[0].length - 1;
        int newBaseMask = key.length - 1;
        int base = 0;
        int displ = 0;
        long i = this.size;
        while (i-- != 0L) {
            while (!used[base][displ]) {
                base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
            }
            int k = key[base][displ];
            long h = HashCommon.murmurHash3((long)k);
            int d = (int)(h & (long)newSegmentMask);
            int b = (int)((h & newMask) >>> 27);
            while (newUsed[b][d]) {
                b = b + ((d = d + 1 & newSegmentMask) == 0 ? 1 : 0) & newBaseMask;
            }
            newUsed[b][d] = true;
            newKey[b][d] = k;
            base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
        }
        this.n = newN;
        this.key = newKey;
        this.used = newUsed;
        this.initMasks();
        this.maxFill = HashCommon.maxFill(this.n, this.f);
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size);
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public IntOpenHashBigSet clone() {
        IntOpenHashBigSet c;
        try {
            c = (IntOpenHashBigSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = IntBigArrays.copy(this.key);
        c.used = BooleanBigArrays.copy(this.used);
        return c;
    }

    @Override
    public int hashCode() {
        boolean[][] used = this.used;
        int[][] key = this.key;
        int h = 0;
        int base = 0;
        int displ = 0;
        long j = this.size;
        while (j-- != 0L) {
            while (!used[base][displ]) {
                base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
            }
            h += key[base][displ];
            base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        IntIterator i = this.iterator();
        s.defaultWriteObject();
        long j = this.size;
        while (j-- != 0L) {
            s.writeInt(i.nextInt());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.bigArraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = IntBigArrays.newBigArray(this.n);
        int[][] key = this.key;
        this.used = BooleanBigArrays.newBigArray(this.n);
        boolean[][] used = this.used;
        this.initMasks();
        long i = this.size;
        while (i-- != 0L) {
            int k = s.readInt();
            long h = HashCommon.murmurHash3((long)k);
            int base = (int)((h & this.mask) >>> 27);
            int displ = (int)(h & (long)this.segmentMask);
            while (used[base][displ]) {
                base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
            }
            used[base][displ] = true;
            key[base][displ] = k;
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    extends AbstractIntIterator {
        int base;
        int displ;
        int lastBase;
        int lastDispl;
        long c;

        private SetIterator() {
            this.c = IntOpenHashBigSet.this.size;
            this.lastBase = -1;
            boolean[][] used = IntOpenHashBigSet.this.used;
            if (this.c != 0L) {
                while (!used[this.base][this.displ]) {
                    this.displ = this.displ + 1 & IntOpenHashBigSet.this.segmentMask;
                    this.base += this.displ == 0 ? 1 : 0;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0L;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastBase = this.base;
            this.lastDispl = this.displ;
            int retVal = IntOpenHashBigSet.this.key[this.lastBase][this.lastDispl];
            if (--this.c != 0L) {
                boolean[][] used = IntOpenHashBigSet.this.used;
                do {
                    this.base = this.base + ((this.displ = this.displ + 1 & IntOpenHashBigSet.this.segmentMask) == 0 ? 1 : 0) & IntOpenHashBigSet.this.baseMask;
                } while (!used[this.base][this.displ]);
            }
            return retVal;
        }

        public void remove() {
            if (this.lastBase == -1) {
                throw new IllegalStateException();
            }
            --IntOpenHashBigSet.this.size;
            IntOpenHashBigSet.this.shiftKeys((long)this.lastBase * 0x8000000L + (long)this.lastDispl);
            this.lastBase = -1;
        }
    }
}

