/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ShortMap;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ShortSortedMap;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.AbstractShortSortedSet;
import it.unimi.dsi.fastutil.shorts.Short2ShortMap;
import it.unimi.dsi.fastutil.shorts.Short2ShortSortedMap;
import it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Short2ShortLinkedOpenHashMap
extends AbstractShort2ShortSortedMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient short[] key;
    protected transient short[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Short2ShortSortedMap.FastSortedEntrySet entries;
    protected volatile transient ShortSortedSet keys;
    protected volatile transient ShortCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Short2ShortLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new short[this.n];
        this.value = new short[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Short2ShortLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Short2ShortLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Short2ShortLinkedOpenHashMap(Map<? extends Short, ? extends Short> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Short2ShortLinkedOpenHashMap(Map<? extends Short, ? extends Short> m) {
        this(m, 0.75f);
    }

    public Short2ShortLinkedOpenHashMap(Short2ShortMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Short2ShortLinkedOpenHashMap(Short2ShortMap m) {
        this(m, 0.75f);
    }

    public Short2ShortLinkedOpenHashMap(short[] k, short[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Short2ShortLinkedOpenHashMap(short[] k, short[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public short put(short k, short v) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                short oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Short put(Short ok, Short ov) {
        short v = ov;
        short k = ok;
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                Short oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos]) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
    }

    @Override
    public short remove(short k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                this.fixPointers(pos);
                short v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Short remove(Object ok) {
        short k = (Short)ok;
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                this.fixPointers(pos);
                short v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Short get(Short ok) {
        short k = ok;
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public short get(short k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(short k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(short v) {
        short[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public short firstShortKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public short lastShortKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public ShortComparator comparator() {
        return null;
    }

    @Override
    public Short2ShortSortedMap tailMap(short from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short2ShortSortedMap headMap(short to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short2ShortSortedMap subMap(short from, short to) {
        throw new UnsupportedOperationException();
    }

    public Short2ShortSortedMap.FastSortedEntrySet short2ShortEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ShortSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ShortCollection values() {
        if (this.values == null) {
            this.values = new AbstractShortCollection(){

                public ShortIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Short2ShortLinkedOpenHashMap.this.size;
                }

                public boolean contains(short v) {
                    return Short2ShortLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Short2ShortLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        short[] key = this.key;
        short[] value = this.value;
        int newMask = newN - 1;
        short[] newKey = new short[newN];
        short[] newValue = new short[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            short k = key[i];
            int pos = HashCommon.murmurHash3(k) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Short2ShortLinkedOpenHashMap clone() {
        Short2ShortLinkedOpenHashMap c;
        try {
            c = (Short2ShortLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (short[])this.key.clone();
        c.value = (short[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        short[] key = this.key;
        short[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeShort(key[e]);
            s.writeShort(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new short[this.n];
        short[] key = this.key;
        this.value = new short[this.n];
        short[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            short k = s.readShort();
            short v = s.readShort();
            pos = HashCommon.murmurHash3(k) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ShortListIterator {
        public short previousShort() {
            return Short2ShortLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Short previous() {
            return Short2ShortLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public void set(Short ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Short ok) {
            throw new UnsupportedOperationException();
        }

        public void set(short v) {
            throw new UnsupportedOperationException();
        }

        public void add(short v) {
            throw new UnsupportedOperationException();
        }

        public short nextShort() {
            return Short2ShortLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public Short next() {
            return Short2ShortLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractShortSortedSet {
        private KeySet() {
        }

        public ShortBidirectionalIterator iterator(short from) {
            return new KeyIterator(from);
        }

        public ShortBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Short2ShortLinkedOpenHashMap.this.size;
        }

        public boolean contains(short k) {
            return Short2ShortLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(short k) {
            int oldSize = Short2ShortLinkedOpenHashMap.this.size;
            Short2ShortLinkedOpenHashMap.this.remove(k);
            return Short2ShortLinkedOpenHashMap.this.size != oldSize;
        }

        public void clear() {
            Short2ShortLinkedOpenHashMap.this.clear();
        }

        public short firstShort() {
            if (Short2ShortLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Short2ShortLinkedOpenHashMap.this.key[Short2ShortLinkedOpenHashMap.this.first];
        }

        public short lastShort() {
            if (Short2ShortLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Short2ShortLinkedOpenHashMap.this.key[Short2ShortLinkedOpenHashMap.this.last];
        }

        public ShortComparator comparator() {
            return null;
        }

        public final ShortSortedSet tailSet(short from) {
            throw new UnsupportedOperationException();
        }

        public final ShortSortedSet headSet(short to) {
            throw new UnsupportedOperationException();
        }

        public final ShortSortedSet subSet(short from, short to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ShortListIterator {
        public KeyIterator(short k) {
            super(k);
        }

        public short previousShort() {
            return Short2ShortLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(short k) {
            throw new UnsupportedOperationException();
        }

        public void add(short k) {
            throw new UnsupportedOperationException();
        }

        public Short previous() {
            return Short2ShortLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(Short ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Short ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        public short nextShort() {
            return Short2ShortLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public Short next() {
            return Short2ShortLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSortedSet<Short2ShortMap.Entry>
    implements Short2ShortSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Short2ShortMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Short2ShortMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Short2ShortMap.Entry> subSet(Short2ShortMap.Entry fromElement, Short2ShortMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Short2ShortMap.Entry> headSet(Short2ShortMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Short2ShortMap.Entry> tailSet(Short2ShortMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Short2ShortMap.Entry first() {
            if (Short2ShortLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Short2ShortLinkedOpenHashMap.this.first);
        }

        @Override
        public Short2ShortMap.Entry last() {
            if (Short2ShortLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Short2ShortLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            short k = (Short)e.getKey();
            int pos = HashCommon.murmurHash3(k) & Short2ShortLinkedOpenHashMap.this.mask;
            while (Short2ShortLinkedOpenHashMap.this.used[pos]) {
                if (k == Short2ShortLinkedOpenHashMap.this.key[pos]) {
                    return Short2ShortLinkedOpenHashMap.this.value[pos] == (Short)e.getValue();
                }
                pos = pos + 1 & Short2ShortLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            short k = (Short)e.getKey();
            int pos = HashCommon.murmurHash3(k) & Short2ShortLinkedOpenHashMap.this.mask;
            while (Short2ShortLinkedOpenHashMap.this.used[pos]) {
                if (k == Short2ShortLinkedOpenHashMap.this.key[pos]) {
                    Short2ShortLinkedOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Short2ShortLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Short2ShortLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Short2ShortLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Short2ShortMap.Entry> iterator(Short2ShortMap.Entry from) {
            return new EntryIterator((Short)from.getKey());
        }

        public ObjectBidirectionalIterator<Short2ShortMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Short2ShortMap.Entry> fastIterator(Short2ShortMap.Entry from) {
            return new FastEntryIterator((Short)from.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Short2ShortMap.Entry> {
        final AbstractShort2ShortMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractShort2ShortMap.BasicEntry(0, 0);
        }

        public FastEntryIterator(short from) {
            super(from);
            this.entry = new AbstractShort2ShortMap.BasicEntry(0, 0);
        }

        @Override
        public AbstractShort2ShortMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Short2ShortLinkedOpenHashMap.this.key[e];
            this.entry.value = Short2ShortLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractShort2ShortMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Short2ShortLinkedOpenHashMap.this.key[e];
            this.entry.value = Short2ShortLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Short2ShortMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Short2ShortMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Short2ShortMap.Entry> {
        public EntryIterator() {
        }

        public EntryIterator(short from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Short2ShortMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Short2ShortMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Short2ShortLinkedOpenHashMap.this.first;
        }

        private MapIterator(short from) {
            if (Short2ShortLinkedOpenHashMap.this.key[Short2ShortLinkedOpenHashMap.this.last] == from) {
                this.prev = Short2ShortLinkedOpenHashMap.this.last;
                this.index = Short2ShortLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Short2ShortLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Short2ShortLinkedOpenHashMap.this.first;
                while (Short2ShortLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Short2ShortLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Short2ShortLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Short2ShortLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Short2ShortLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Short2ShortLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Short2ShortLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Short2ShortLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Short2ShortLinkedOpenHashMap.this.link[n] = Short2ShortLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Short2ShortLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Short2ShortLinkedOpenHashMap.this.link[n] = Short2ShortLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Short2ShortLinkedOpenHashMap.this.mask;
                while (Short2ShortLinkedOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Short2ShortLinkedOpenHashMap.this.key[pos]) & Short2ShortLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Short2ShortLinkedOpenHashMap.this.mask;
                }
                if (!Short2ShortLinkedOpenHashMap.this.used[pos]) break;
                Short2ShortLinkedOpenHashMap.this.key[last] = Short2ShortLinkedOpenHashMap.this.key[pos];
                Short2ShortLinkedOpenHashMap.this.value[last] = Short2ShortLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Short2ShortLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Short2ShortLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Short2ShortMap.Entry,
    Map.Entry<Short, Short> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Short getKey() {
            return Short2ShortLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public short getShortKey() {
            return Short2ShortLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Short getValue() {
            return Short2ShortLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public short getShortValue() {
            return Short2ShortLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public short setValue(short v) {
            short oldValue = Short2ShortLinkedOpenHashMap.this.value[this.index];
            Short2ShortLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Short setValue(Short v) {
            return this.setValue((short)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Short2ShortLinkedOpenHashMap.this.key[this.index] == (Short)e.getKey() && Short2ShortLinkedOpenHashMap.this.value[this.index] == (Short)e.getValue();
        }

        @Override
        public int hashCode() {
            return Short2ShortLinkedOpenHashMap.this.key[this.index] ^ Short2ShortLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Short2ShortLinkedOpenHashMap.this.key[this.index] + "=>" + Short2ShortLinkedOpenHashMap.this.value[this.index];
        }
    }
}

