/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagecomparison;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import net.avh4.util.imagecomparison.ImageComparisonResult;
import net.avh4.util.imagecomparison.ImageComparisonSuccess;
import net.avh4.util.imagecomparison.NoReferenceImageResult;
import net.avh4.util.imagecomparison.PixelMismatchResult;
import net.avh4.util.imagecomparison.SizeMismatchResult;
import net.avh4.util.imagerender.ImageRenderer;

public class ImageComparison {
    public static ImageComparisonResult compare(Object actual, Object reference) {
        BufferedImage actualImage = ImageRenderer.getImage(actual);
        if (reference == null) {
            return new NoReferenceImageResult(actualImage);
        }
        BufferedImage referenceImage = ImageRenderer.getImage(reference);
        if (actualImage.getWidth() != referenceImage.getWidth() || actualImage.getHeight() != referenceImage.getHeight()) {
            return new SizeMismatchResult(actualImage, actualImage.getWidth(), actualImage.getHeight(), referenceImage.getWidth(), referenceImage.getHeight());
        }
        for (int size : actualImage.getColorModel().getComponentSize()) {
            if (size <= 8) continue;
            throw new RuntimeException("Don't know how to handle images with more than 8 bits per channel");
        }
        for (int size : referenceImage.getColorModel().getComponentSize()) {
            if (size <= 8) continue;
            throw new RuntimeException("Don't know how to handle reference images with more than 8 bits per channel");
        }
        Raster itemRaster = actualImage.getData();
        Raster referenceRaster = referenceImage.getData();
        int itemBands = itemRaster.getNumBands();
        int referenceBands = referenceRaster.getNumBands();
        if (itemBands < 3) {
            throw new RuntimeException("Don't know how to handle images with less than 3 data bands (expecting RGB or ARGB color model)");
        }
        if (itemBands > 4) {
            throw new RuntimeException("Don't know how to handle images with more than 4 data bands (expecting RGB or ARGB color model)");
        }
        if (referenceBands < 3) {
            throw new RuntimeException("Don't know how to handle reference images with less than 3 data bands (expecting RGB or ARGB color model)");
        }
        if (referenceBands > 4) {
            throw new RuntimeException("Don't know how to handle reference images with more than 4 data bands (expecting RGB or ARGB color model)");
        }
        int width = itemRaster.getWidth();
        int height = itemRaster.getHeight();
        int[] itemPixels = new int[itemBands * width];
        int[] referencePixels = new int[referenceBands * width];
        for (int y = 0; y < height; ++y) {
            itemRaster.getPixels(0, y, width, 1, itemPixels);
            referenceRaster.getPixels(0, y, width, 1, referencePixels);
            for (int x = 0; x < width; ++x) {
                int referenceAlpha;
                int referencePixel;
                int itemAlpha = itemBands == 4 ? itemPixels[x * itemBands + 3] & 0xFF : 255;
                int itemPixel = itemPixels[x * itemBands] & 0xFF | (itemPixels[x * itemBands + 1] & 0xFF) << 8 | (itemPixels[x * itemBands + 2] & 0xFF) << 16 | itemAlpha << 24;
                if (itemPixel == (referencePixel = referencePixels[x * referenceBands] & 0xFF | (referencePixels[x * referenceBands + 1] & 0xFF) << 8 | (referencePixels[x * referenceBands + 2] & 0xFF) << 16 | (referenceAlpha = referenceBands == 4 ? referencePixels[x * referenceBands + 3] & 0xFF : 255) << 24)) continue;
                return new PixelMismatchResult(actualImage, x, y, itemPixel, referencePixel);
            }
        }
        return new ImageComparisonSuccess(actualImage);
    }
}

