/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagecomparison;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public abstract class ImageComparisonResult {
    protected final BufferedImage actualImage;

    public ImageComparisonResult(BufferedImage actualImage) {
        this.actualImage = actualImage;
    }

    public abstract boolean isEqual();

    private static void write(BufferedImage image, String filename) {
        String safeFilename = filename.replaceFirst("^.*/+", "");
        try {
            ImageIO.write((RenderedImage)image, "png", new File(safeFilename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeActualImageToFile(String filename) {
        ImageComparisonResult.write(this.actualImage, filename);
    }

    public abstract String getFailureMessage();
}

