/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagecomparison.hamcrest;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import net.avh4.util.imagecomparison.hamcrest.LooksLikeMatcher;
import net.avh4.util.reflection.StackUtils;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ImageComparisonMatchers {
    @Factory
    public static Matcher<Object> looksLike(String string) throws IOException {
        return new LooksLikeMatcher(string);
    }

    @Factory
    public static Matcher<Object> looksLike(String string, Class<?> callingClass) throws IOException {
        return new LooksLikeMatcher(string, callingClass);
    }

    @Factory
    public static Matcher<Object> isApproved() throws IOException {
        StackTraceElement trace = StackUtils.getCallingTestMethodStackTraceElement();
        String methodName = trace.getMethodName();
        String className = ImageComparisonMatchers.getClassName(trace);
        Class<?> clazz = ImageComparisonMatchers.getClassObject(trace);
        return ImageComparisonMatchers.looksLike(String.format("%s.%s.png", className, methodName), clazz);
    }

    private static Class<?> getClassObject(StackTraceElement trace) {
        try {
            return Class.forName(trace.getClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getClassName(StackTraceElement trace) {
        return trace.getClassName().replaceAll("^[a-z0-9.]*", "").replaceAll("\\$", ".");
    }

    @Factory
    public static Matcher<String> matchesFile(final String filename) throws IOException {
        Class<?> clazz = StackUtils.getCallingClass(new Class[0]);
        InputStream is = clazz.getResourceAsStream(filename);
        StringWriter sw = null;
        if (is != null) {
            sw = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)sw);
        }
        final String expected = sw == null ? null : sw.toString();
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String actual) {
                if (actual.equals(expected)) {
                    return true;
                }
                try {
                    FileOutputStream fo = new FileOutputStream(filename);
                    IOUtils.write((String)actual, (OutputStream)fo);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }

            public void describeTo(Description arg0) {
                arg0.appendText("a String matching " + filename);
            }
        };
    }
}

