/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagerender;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import net.avh4.util.imagerender.Renderer;
import net.avh4.util.imagerender.UnrenderableException;

public class ImageRenderer {
    private static final ServiceLoader<Renderer> rendererLoader = ServiceLoader.load(Renderer.class);

    public static BufferedImage getImage(Object item) {
        if (item == null) {
            throw new UnrenderableException(item, ImageRenderer.getRenderers());
        }
        if (item instanceof BufferedImage) {
            return (BufferedImage)item;
        }
        for (Renderer r : rendererLoader) {
            BufferedImage rendering = r.getImage(item);
            if (rendering == null) continue;
            return rendering;
        }
        throw new UnrenderableException(item, ImageRenderer.getRenderers());
    }

    public static List<Renderer> getRenderers() {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        for (Renderer renderer : rendererLoader) {
            renderers.add(renderer);
        }
        return renderers;
    }
}

