/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.target.occi.internal;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.userdata.UserDataHelpers;
import net.roboconf.target.api.AbstractThreadedTargetHandler;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.api.TargetHandlerParameters;
import net.roboconf.target.occi.internal.OcciMachineConfigurator;
import net.roboconf.target.occi.internal.OcciVMUtils;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class OcciIaasHandler
extends AbstractThreadedTargetHandler
implements Pojo {
    InstanceManager __IM;
    public static final String TARGET_ID = "iaas-occi";
    static final String SERVER_IP_PORT = "occi.serverIpPort";
    static final String IMAGE = "occi.image";
    static final String TITLE = "occi.title";
    static final String SUMMARY = "occi.summary";
    static final String USER = "occi.user";
    static final String PASSWORD = "occi.password";
    static final String RENDERING = "occi.rendering";
    private boolean __Flogger;
    private final Logger logger;
    boolean __MgetTargetId;
    boolean __McreateMachine$net_roboconf_target_api_TargetHandlerParameters;
    boolean __MmachineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    public OcciIaasHandler() {
        this(null);
    }

    private OcciIaasHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(Logger.getLogger(((Object)((Object)this)).getClass().getName()));
    }

    public String getTargetId() {
        String string;
        if (!this.__MgetTargetId) {
            return this.__M_getTargetId();
        }
        try {
            this.__IM.onEntry((Object)this, "getTargetId", new Object[0]);
            string = this.__M_getTargetId();
            this.__IM.onExit((Object)this, "getTargetId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTargetId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getTargetId() {
        return TARGET_ID;
    }

    public String createMachine(TargetHandlerParameters parameters) throws TargetException {
        String string;
        if (!this.__McreateMachine$net_roboconf_target_api_TargetHandlerParameters) {
            return this.__M_createMachine(parameters);
        }
        try {
            this.__IM.onEntry((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", new Object[]{parameters});
            string = this.__M_createMachine(parameters);
            this.__IM.onExit((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_createMachine(TargetHandlerParameters parameters) throws TargetException {
        this.__getlogger().fine("Creating a new VM @ OCCI.");
        if (InstanceHelpers.countInstances((String)parameters.getScopedInstancePath()) > 1) {
            throw new TargetException("Only root instances can be passed in arguments.");
        }
        try {
            UUID id = UUID.randomUUID();
            Map targetProperties = parameters.getTargetProperties();
            String userData = UserDataHelpers.writeUserDataAsString((Map)parameters.getMessagingProperties(), (String)parameters.getDomain(), (String)parameters.getApplicationName(), (String)parameters.getScopedInstancePath());
            if ("json".equalsIgnoreCase((String)targetProperties.get(RENDERING))) {
                return OcciVMUtils.createVMJson((String)targetProperties.get(SERVER_IP_PORT), id.toString(), (String)targetProperties.get(IMAGE), (String)targetProperties.get(TITLE), (String)targetProperties.get(SUMMARY), userData, (String)targetProperties.get(USER), (String)targetProperties.get(PASSWORD), targetProperties, false);
            }
            return OcciVMUtils.createVM((String)targetProperties.get(SERVER_IP_PORT), id.toString(), (String)targetProperties.get(IMAGE), (String)targetProperties.get(TITLE), (String)targetProperties.get(SUMMARY), userData, (String)targetProperties.get(USER), (String)targetProperties.get(PASSWORD), targetProperties);
        }
        catch (Exception e) {
            throw new TargetException((Throwable)e);
        }
    }

    public AbstractThreadedTargetHandler.MachineConfigurator machineConfigurator(TargetHandlerParameters parameters, String machineId) throws TargetException {
        AbstractThreadedTargetHandler.MachineConfigurator machineConfigurator;
        if (!this.__MmachineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_machineConfigurator(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            machineConfigurator = this.__M_machineConfigurator(parameters, machineId);
            this.__IM.onExit((Object)this, "machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)machineConfigurator);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return machineConfigurator;
    }

    private AbstractThreadedTargetHandler.MachineConfigurator __M_machineConfigurator(TargetHandlerParameters parameters, String machineId) throws TargetException {
        try {
            Properties userData = UserDataHelpers.writeUserDataAsProperties((Map)parameters.getMessagingProperties(), (String)parameters.getDomain(), (String)parameters.getApplicationName(), (String)parameters.getScopedInstancePath());
            String rootInstanceName = InstanceHelpers.findRootInstancePath((String)parameters.getScopedInstancePath());
            return new OcciMachineConfigurator(machineId, parameters.getTargetProperties(), userData, rootInstanceName, parameters.getScopedInstance());
        }
        catch (IOException e) {
            throw new TargetException((Throwable)e);
        }
    }

    public boolean isMachineRunning(TargetHandlerParameters parameters, String machineId) throws TargetException {
        boolean bl;
        if (!this.__MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_isMachineRunning(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            bl = this.__M_isMachineRunning(parameters, machineId);
            this.__IM.onExit((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isMachineRunning(TargetHandlerParameters parameters, String machineId) throws TargetException {
        return OcciVMUtils.isVMRunning((String)parameters.getTargetProperties().get(SERVER_IP_PORT), machineId);
    }

    public void terminateMachine(TargetHandlerParameters parameters, String machineId) throws TargetException {
        if (!this.__MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            this.__M_terminateMachine(parameters, machineId);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            this.__M_terminateMachine(parameters, machineId);
            this.__IM.onExit((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_terminateMachine(TargetHandlerParameters parameters, String machineId) throws TargetException {
        try {
            OcciVMUtils.deleteVM((String)parameters.getTargetProperties().get(SERVER_IP_PORT), machineId);
        }
        catch (TargetException targetException) {
            // empty catch block
        }
    }

    public String retrievePublicIpAddress(TargetHandlerParameters parameters, String machineId) throws TargetException {
        String string;
        if (!this.__MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_retrievePublicIpAddress(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            string = this.__M_retrievePublicIpAddress(parameters, machineId);
            this.__IM.onExit((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_retrievePublicIpAddress(TargetHandlerParameters parameters, String machineId) throws TargetException {
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("logger")) {
            this.__Flogger = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getTargetId")) {
                this.__MgetTargetId = true;
            }
            if (set.contains("createMachine$net_roboconf_target_api_TargetHandlerParameters")) {
                this.__McreateMachine$net_roboconf_target_api_TargetHandlerParameters = true;
            }
            if (set.contains("machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MmachineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

