/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.target.occi.internal;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.target.api.AbstractThreadedTargetHandler;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.occi.internal.OcciVMUtils;

public class OcciMachineConfigurator
implements AbstractThreadedTargetHandler.MachineConfigurator {
    private State state = State.STARTING_VM;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String machineId;
    private final Map<String, String> targetProperties;
    private final Instance scopedInstance;

    public OcciMachineConfigurator(String machineId, Map<String, String> targetProperties, Properties userData, String rootInstanceName, Instance scopedInstance) {
        this.machineId = machineId;
        this.targetProperties = targetProperties;
        this.scopedInstance = scopedInstance;
    }

    public Instance getScopedInstance() {
        return this.scopedInstance;
    }

    public void close() throws IOException {
    }

    public boolean configure() throws TargetException {
        try {
            if (this.state == State.STARTING_VM && OcciVMUtils.isVMRunning(this.targetProperties.get("occi.serverIpPort"), this.machineId)) {
                this.state = State.RUNNING_VM;
            }
            if (this.state == State.RUNNING_VM) {
                this.logger.info("VM up and running, configuration complete !");
                this.state = State.COMPLETE;
            }
            return this.state == State.COMPLETE;
        }
        catch (Exception e) {
            throw new TargetException((Throwable)e);
        }
    }

    public static enum State {
        STARTING_VM,
        RUNNING_VM,
        COMPLETE;

    }
}

