/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.target.occi.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.occi.internal.JsonResponse;

public class OcciVMUtils {
    public static String createVM(String hostIpPort, String id, String template, String title, String summary, String userData, String user, String password, Map<String, String> config) throws TargetException {
        if (hostIpPort.contains("multi-language-connector")) {
            return OcciVMUtils.createCloudAutomationVM(hostIpPort, template, title, userData, config, false);
        }
        String ret = null;
        URL url = null;
        try {
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            url = new URL("http://" + hostIpPort + "/compute/" + id);
        }
        catch (MalformedURLException e) {
            throw new TargetException((Throwable)e);
        }
        if (Utils.isEmptyOrWhitespaces((String)title)) {
            title = "Roboconf";
        }
        if (Utils.isEmptyOrWhitespaces((String)summary)) {
            summary = "Generated by Roboconf";
        }
        HttpURLConnection httpURLConnection = null;
        DataInputStream in = null;
        try {
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("PUT");
            httpURLConnection.setRequestProperty("Content-Type", "text/occi");
            httpURLConnection.setRequestProperty("Accept", "*/*");
            StringBuffer category = new StringBuffer("compute; scheme=\"http://schemas.ogf.org/occi/infrastructure#\"; class=\"kind\"");
            if (template != null) {
                category.append(", medium; scheme=\"http://schemas.ogf.org/occi/infrastructure/compute/template/1.1#\"; class=\"mixin\", vmimage; scheme=\"http://occiware.org/occi/infrastructure/crtp/backend#vmimage\"; class=\"mixin\", vmwarefolders; scheme=\"http://occiware.org/occi/infrastructure/crtp/backend#vmwarefolders\"; class=\"mixin\", user_data; scheme=\"http://occiware.org/occi/infrastructure/compute#user_data\"; class=\"mixin\", credential; scheme=\"http://occiware.org/occi/infrastructure/crtp/backend#credential\"; class=\"mixin\"");
            }
            category.append(";");
            httpURLConnection.setRequestProperty("Category", category.toString());
            httpURLConnection.addRequestProperty("X-OCCI-Attribute", "occi.core.id=\"" + id + "\"");
            httpURLConnection.addRequestProperty("X-OCCI-Attribute", "occi.core.title=\"" + title + "\"");
            httpURLConnection.addRequestProperty("X-OCCI-Attribute", "occi.core.summary=\"" + summary + "\"");
            httpURLConnection.addRequestProperty("X-OCCI-Attribute", "occi.compute.architecture=\"x64\"");
            httpURLConnection.addRequestProperty("X-OCCI-Attribute", "occi.compute.cores=2");
            httpURLConnection.addRequestProperty("X-OCCI-Attribute", "occi.compute.memory=2");
            httpURLConnection.addRequestProperty("X-OCCI-Attribute", "occi.compute.state=\"active\"");
            if (template != null) {
                httpURLConnection.addRequestProperty("X-OCCI-Attribute", "imagename=\"" + template + "\"");
                httpURLConnection.addRequestProperty("X-OCCI-Attribute", "datacentername=\"" + config.get("vmwarefolders.datacentername") + "\"");
                httpURLConnection.addRequestProperty("X-OCCI-Attribute", "datastorename=\"" + config.get("vmwarefolders.datastorename") + "\"");
                httpURLConnection.addRequestProperty("X-OCCI-Attribute", "clustername=\"" + config.get("vmwarefolders.clustername") + "\"");
                httpURLConnection.addRequestProperty("X-OCCI-Attribute", "hostsystemname=\"" + config.get("vmwarefolders.hostsystemname") + "\"");
                httpURLConnection.addRequestProperty("X-OCCI-Attribute", "inventorypath=\"" + config.get("vmwarefolders.inventorypath") + "\"");
            }
            if (!Utils.isEmptyOrWhitespaces((String)userData)) {
                String userDataScript = "printf '" + userData.replaceAll("\n\r", "\\\\n").replaceAll("\n", "\\\\n").replaceAll(System.lineSeparator(), "\\\\n") + "' > /tmp/roboconf.properties";
                httpURLConnection.addRequestProperty("X-OCCI-Attribute", "occi.compute.userdata=\"" + userDataScript + "\"");
                if (Utils.isEmptyOrWhitespaces((String)user)) {
                    user = "";
                }
                httpURLConnection.addRequestProperty("X-OCCI-Attribute", "user=\"" + user + "\"");
                if (Utils.isEmptyOrWhitespaces((String)password)) {
                    password = "";
                }
                httpURLConnection.addRequestProperty("X-OCCI-Attribute", "password=\"" + password + "\"");
            }
            in = new DataInputStream(httpURLConnection.getInputStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)out);
            ret = out.toString("UTF-8");
        }
        catch (IOException e) {
            try {
                throw new TargetException((Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(in);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
        Utils.closeQuietly((InputStream)in);
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return "OK".equalsIgnoreCase(ret.trim()) ? id : null;
    }

    public static String createVMJson(String hostIpPort, String id, String template, String title, String summary, String userData, String user, String password, Map<String, String> config, boolean waitForActive) throws TargetException {
        DataOutputStream output;
        DataInputStream in;
        HttpURLConnection httpURLConnection;
        String vmId;
        block14: {
            if (hostIpPort.contains("multi-language-connector")) {
                return OcciVMUtils.createCloudAutomationVM(hostIpPort, template, title, userData, config, false);
            }
            vmId = null;
            URL url = null;
            try {
                CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
                url = new URL("http://" + hostIpPort + "/vm/");
            }
            catch (MalformedURLException e) {
                throw new TargetException((Throwable)e);
            }
            httpURLConnection = null;
            in = null;
            output = null;
            try {
                httpURLConnection = (HttpURLConnection)url.openConnection();
                httpURLConnection.setRequestMethod("PUT");
                httpURLConnection.setRequestProperty("Content-Type", "application/json");
                httpURLConnection.setRequestProperty("Accept", "application/json");
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                String userDataString = "name: value";
                if (userData != null) {
                    userDataString = userData.replaceAll("\n\r", "\\\\n").replaceAll("\n", "\\\\n").replaceAll(System.lineSeparator(), "\\\\n");
                }
                String request = "{\n\"id\": \"" + id + "\",\n\"title\": \"" + title + "\",\n\"summary\": \"" + summary + "\",\n\"kind\": \"http://schemas.ogf.org/occi/infrastructure#compute\",\n\"mixins\": [\"http://occiware.org/occi/infrastructure/crtp/backend#vmimage\",\n\"http://occiware.org/occi/infrastructure/crtp/backend#vmwarefolders\",\n\"http://schemas.ogf.org/occi/infrastructure/compute#user_data\",\n\"http://occiware.org/occi/infrastructure/crtp/backend#credential\"\n],\n\"attributes\": {\n\"occi.compute.state\": \"active\",\n\"occi.compute.speed\": " + 3 + ",\n\"occi.compute.memory\": " + 2 + ",\n\"occi.compute.cores\": " + 2 + ",\n\"occi.compute.architecture\": \"x64\",\n\"imagename\": \"" + template + "\",\n\"datacentername\": \"" + config.get("vmwarefolders.datacentername") + "\",\n\"datastorename\": \"" + config.get("vmwarefolders.datastorename") + "\",\n\"clustername\": \"" + config.get("vmwarefolders.clustername") + "\",\n\"hostsystemname\": \"" + config.get("vmwarefolders.hostsystemname") + "\",\n\"inventorypath\": \"" + config.get("vmwarefolders.inventorypath") + "\",\n\"occi.compute.userdata\": \"" + userDataString + "\",\n\"user\": \"" + user + "\",\n\"password\": \"" + password + "\"\n}\n}";
                Logger logger = Logger.getLogger(OcciVMUtils.class.getName());
                logger.finest(request);
                httpURLConnection.setRequestProperty("Content-Length", Integer.toString(request.getBytes(StandardCharsets.UTF_8).length));
                output = new DataOutputStream(httpURLConnection.getOutputStream());
                output.writeBytes(request);
                output.flush();
                Utils.closeQuietly((OutputStream)output);
                output = null;
                in = new DataInputStream(httpURLConnection.getInputStream());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)out);
                ObjectMapper objectMapper = new ObjectMapper();
                JsonResponse rsp = objectMapper.readValue(out.toString("UTF-8"), JsonResponse.class);
                vmId = rsp.getId();
                if (Utils.isEmptyOrWhitespaces((String)vmId)) break block14;
                if (vmId.startsWith("urn:uuid:")) {
                    vmId = vmId.substring(9);
                }
                if (!waitForActive) break block14;
                int retries = 15;
                boolean active = false;
                while (!active && retries-- > 0) {
                    logger.finest("retry: " + retries);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    active = !Utils.isEmptyOrWhitespaces((String)OcciVMUtils.getVMIP(hostIpPort, vmId));
                }
            }
            catch (IOException e) {
                try {
                    throw new TargetException((Throwable)e);
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(in);
                    Utils.closeQuietly(output);
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    throw throwable;
                }
            }
        }
        Utils.closeQuietly((InputStream)in);
        Utils.closeQuietly((OutputStream)output);
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return vmId;
    }

    public static String createCloudAutomationVM(String hostIpPort, String image, String title, String userData, Map<String, String> config, boolean waitForActive) throws TargetException {
        DataOutputStream output;
        DataInputStream in;
        HttpURLConnection httpURLConnection;
        String vmId;
        block12: {
            vmId = null;
            URL url = null;
            try {
                CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
                url = new URL("http://" + hostIpPort + "/compute/");
            }
            catch (MalformedURLException e) {
                throw new TargetException((Throwable)e);
            }
            httpURLConnection = null;
            in = null;
            output = null;
            try {
                httpURLConnection = (HttpURLConnection)url.openConnection();
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Content-Type", "application/json");
                httpURLConnection.setRequestProperty("Accept", "application/json");
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                String userDataScript = "printf test > /tmp/roboconf.properties";
                if (userData != null) {
                    userDataScript = "printf '" + userData.replaceAll("\n\r", "\\\\n").replaceAll("\n", "\\\\n").replaceAll(System.lineSeparator(), "\\\\n") + "' > /tmp/roboconf.properties";
                }
                String request = "{\n\"attributes\": {\n\"occi.entity.title\": \"" + title + "\",\n\"vmimage\": {\n\"imagename\": \"" + image + "\",\n\"occi.category.title\": \"ubuntuMixin\"\n},\n\"user_data\": {\n\"occi.compute.userdata\": \"" + userDataScript + "\",\n\"occi.category.title\": \"scriptMixin\"\n}\n}\n}";
                Logger logger = Logger.getLogger(OcciVMUtils.class.getName());
                logger.finest(request);
                httpURLConnection.setRequestProperty("Content-Length", Integer.toString(request.getBytes(StandardCharsets.UTF_8).length));
                output = new DataOutputStream(httpURLConnection.getOutputStream());
                output.writeBytes(request);
                output.flush();
                Utils.closeQuietly((OutputStream)output);
                output = null;
                in = new DataInputStream(httpURLConnection.getInputStream());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)out);
                ObjectMapper objectMapper = new ObjectMapper();
                JsonResponse rsp = objectMapper.readValue(out.toString("UTF-8"), JsonResponse.class);
                vmId = rsp.getId();
                if (!waitForActive || Utils.isEmptyOrWhitespaces((String)vmId)) break block12;
                int retries = 15;
                boolean active = false;
                while (!active && retries-- > 0) {
                    logger.finest("retry: " + retries);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    active = !Utils.isEmptyOrWhitespaces((String)OcciVMUtils.getVMIP(hostIpPort, vmId));
                }
            }
            catch (IOException e) {
                try {
                    throw new TargetException((Throwable)e);
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(in);
                    Utils.closeQuietly(output);
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    throw throwable;
                }
            }
        }
        Utils.closeQuietly((InputStream)in);
        Utils.closeQuietly((OutputStream)output);
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return vmId;
    }

    public static String getVMStatus(String hostIpPort, String id) throws TargetException {
        String status = null;
        URL url = null;
        try {
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            url = new URL("http://" + hostIpPort + "/compute/" + id);
        }
        catch (MalformedURLException e) {
            throw new TargetException((Throwable)e);
        }
        HttpURLConnection httpURLConnection = null;
        DataInputStream in = null;
        try {
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Accept", "application/json");
            in = new DataInputStream(httpURLConnection.getInputStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)out);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonResponse rsp = objectMapper.readValue(out.toString("UTF-8"), JsonResponse.class);
            status = rsp.getState();
        }
        catch (IOException e) {
            try {
                throw new TargetException((Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(in);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
        Utils.closeQuietly((InputStream)in);
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return status;
    }

    public static boolean deleteVM(String hostIpPort, String id) throws TargetException {
        String ret = null;
        URL url = null;
        try {
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            url = hostIpPort.contains("multi-language-connector") ? new URL("http://" + hostIpPort + "/compute/" + id) : new URL("http://" + hostIpPort + "/" + id);
        }
        catch (MalformedURLException e) {
            throw new TargetException((Throwable)e);
        }
        HttpURLConnection httpURLConnection = null;
        DataInputStream in = null;
        try {
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("DELETE");
            httpURLConnection.setRequestProperty("Content-Type", "text/occi");
            httpURLConnection.setRequestProperty("Accept", "*/*");
            in = new DataInputStream(httpURLConnection.getInputStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)out);
            ret = out.toString("UTF-8");
        }
        catch (IOException e) {
            try {
                throw new TargetException((Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(in);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
        Utils.closeQuietly((InputStream)in);
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return "OK".equalsIgnoreCase(ret);
    }

    public static String getVMIP(String hostIpPort, String id) throws TargetException {
        DataInputStream in;
        HttpURLConnection httpURLConnection;
        String vmIp;
        block8: {
            vmIp = null;
            URL url = null;
            try {
                CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
                url = new URL("http://" + hostIpPort + "/compute/" + id);
            }
            catch (MalformedURLException e) {
                throw new TargetException((Throwable)e);
            }
            httpURLConnection = null;
            in = null;
            try {
                httpURLConnection = (HttpURLConnection)url.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setRequestProperty("Accept", "application/json");
                in = new DataInputStream(httpURLConnection.getInputStream());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)out);
                ObjectMapper objectMapper = new ObjectMapper();
                JsonResponse rsp = objectMapper.readValue(out.toString("UTF-8"), JsonResponse.class);
                vmIp = rsp.getHostsystemname();
                if (!Utils.isEmptyOrWhitespaces((String)vmIp)) break block8;
                vmIp = rsp.getHostname();
            }
            catch (IOException e) {
                try {
                    throw new TargetException((Throwable)e);
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(in);
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    throw throwable;
                }
            }
        }
        Utils.closeQuietly((InputStream)in);
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return vmIp;
    }

    public static boolean isVMRunning(String hostIpPort, String id) throws TargetException {
        boolean result = false;
        String ip = OcciVMUtils.getVMIP(hostIpPort, id);
        try {
            InetAddress inet = InetAddress.getByName(ip);
            result = inet.isReachable(5000);
        }
        catch (Exception e) {
            result = false;
            Logger logger = Logger.getLogger(OcciVMUtils.class.getName());
            logger.info(e.getMessage());
        }
        return result;
    }
}

