/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQInputStreamTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(ActiveMQInputStreamTest.class);
    private static final String BROKER_URL = "tcp://localhost:61616";
    private static final String DESTINATION = "destination";
    private static final int STREAM_LENGTH = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamMatchesDefaultChuckSize() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(false);
        broker.setPersistent(false);
        broker.setDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination(DESTINATION, (byte)1)});
        broker.addConnector(BROKER_URL);
        broker.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(BROKER_URL);
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(DESTINATION);
        OutputStream out = null;
        try {
            out = connection.createOutputStream(destination);
            LOG.debug("writing...");
            for (int i = 0; i < 65536; ++i) {
                out.write(0);
            }
            LOG.debug("wrote 65536 bytes");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        InputStream in = null;
        try {
            in = connection.createInputStream(destination);
            LOG.debug("reading...");
            int count = 0;
            while (-1 != in.read()) {
                ++count;
            }
            LOG.debug("read " + count + " bytes");
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        connection.close();
        broker.stop();
    }
}

