/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.TestSupport;

public class JmsClientAckListenerTest
extends TestSupport
implements MessageListener {
    private Connection connection;
    private boolean dontAck;

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    public void testAckedMessageAreConsumed() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue("test");
        MessageProducer producer = session.createProducer(queue);
        producer.send(session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer(queue);
        consumer.setMessageListener(this);
        Thread.sleep(10000L);
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer(queue);
        Message msg = consumer.receive(1000L);
        JmsClientAckListenerTest.assertNull((Object)msg);
        session.close();
    }

    public void testUnAckedMessageAreNotConsumedOnSessionClose() throws Exception {
        this.connection.start();
        this.dontAck = true;
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue("test");
        MessageProducer producer = session.createProducer(queue);
        producer.send(session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer(queue);
        consumer.setMessageListener(this);
        session.close();
        Thread.sleep(10000L);
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer(queue);
        Message msg = consumer.receive(2000L);
        JmsClientAckListenerTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
    }

    public void onMessage(Message message) {
        JmsClientAckListenerTest.assertNotNull((Object)message);
        if (!this.dontAck) {
            try {
                message.acknowledge();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

