/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.util.UDPTraceBrokerPlugin;
import org.apache.activemq.broker.view.ConnectionDotFilePlugin;

public class TimeStampTest
extends TestCase {
    public void test() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.setUseJmx(true);
        broker.setPlugins(new BrokerPlugin[]{new ConnectionDotFilePlugin(), new UDPTraceBrokerPlugin()});
        broker.addConnector("tcp://localhost:61616");
        broker.addConnector("stomp://localhost:61613");
        broker.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue("TEST.FOO");
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(1);
        Message sentMessage = session.createMessage();
        long beforeSend = System.currentTimeMillis();
        producer.send(sentMessage);
        long afterSend = System.currentTimeMillis();
        TimeStampTest.assertTrue((beforeSend <= sentMessage.getJMSTimestamp() && sentMessage.getJMSTimestamp() <= afterSend ? 1 : 0) != 0);
        MessageConsumer consumer = session.createConsumer(destination);
        Message receivedMessage = consumer.receive(1000L);
        TimeStampTest.assertEquals((String)sentMessage.getJMSMessageID(), (String)receivedMessage.getJMSMessageID());
        TimeStampTest.assertTrue((String)("JMS Message Timestamp should be set during the send method: \n        beforeSend = " + beforeSend + "\n" + "   getJMSTimestamp = " + receivedMessage.getJMSTimestamp() + "\n" + "         afterSend = " + afterSend + "\n"), (beforeSend <= receivedMessage.getJMSTimestamp() && receivedMessage.getJMSTimestamp() <= afterSend ? 1 : 0) != 0);
        TimeStampTest.assertEquals((String)"JMS Message Timestamp of recieved message should be the same as the sent message\n        ", (long)sentMessage.getJMSTimestamp(), (long)receivedMessage.getJMSTimestamp());
        producer.close();
        consumer.close();
        session.close();
        connection.close();
        broker.stop();
    }
}

