/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.VMPendingSubscriberMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;

public class MessageExpirationTest
extends BrokerTestSupport {
    public ActiveMQDestination destination;
    public int deliveryMode;
    public int prefetch;
    public byte destinationType;
    public boolean durableConsumer;

    protected Message createMessage(ProducerInfo producerInfo, ActiveMQDestination destination, int deliveryMode, int timeToLive) {
        Message message = this.createMessage(producerInfo, destination, deliveryMode);
        long now = System.currentTimeMillis();
        message.setTimestamp(now);
        message.setExpiration(now + (long)timeToLive);
        return message;
    }

    public void initCombosForTestMessagesWaitingForUssageDecreaseExpire() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)5, (byte)6, (byte)1, (byte)2});
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        return broker;
    }

    protected PolicyEntry getDefaultPolicy() {
        PolicyEntry policy = super.getDefaultPolicy();
        policy.setPendingSubscriberPolicy(new VMPendingSubscriberMessageStoragePolicy());
        return policy;
    }

    public void XtestMessagesWaitingForUssageDecreaseExpire() throws Exception {
        final StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send(connectionInfo2);
        connection2.send(sessionInfo2);
        this.destination = this.createDestinationInfo(connection2, connectionInfo2, this.destinationType);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, this.destination);
        consumerInfo2.setPrefetchSize(1);
        connection2.request(consumerInfo2);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(1L);
        final Message m1 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        final Message m2 = this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000);
        final Message m3 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        final Message m4 = this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000);
        new Thread(){

            public void run() {
                try {
                    connection.send(m1);
                    connection.send(m2);
                    connection.send(m3);
                    connection.send(m4);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        Message m = this.receiveMessage(connection2);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m1.getMessageId(), (Object)m.getMessageId());
        this.assertNoMessagesLeft(connection);
        Thread.sleep(1500L);
        connection2.send(this.createAck(consumerInfo2, m, 1, (byte)2));
        m = this.receiveMessage(connection2);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m3.getMessageId(), (Object)m.getMessageId());
        Thread.sleep(1500L);
        connection2.send(this.createAck(consumerInfo2, m, 1, (byte)2));
        this.assertNoMessagesLeft(connection2);
        connection.send(this.closeConnectionInfo(connectionInfo));
        connection.send(this.closeConnectionInfo(connectionInfo2));
    }

    public void initCombosForTestMessagesInLongTransactionExpire() {
        this.addCombinationValues("deliveryMode", new Object[]{1});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testMessagesInLongTransactionExpire() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        consumerInfo.setPrefetchSize(1000);
        connection.send(consumerInfo);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo);
        connection.send(this.createBeginTransaction(connectionInfo, txid));
        Message m1 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        m1.setTransactionId(txid);
        connection.send(m1);
        Message m = this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000);
        m.setTransactionId(txid);
        connection.send(m);
        Message m3 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        m3.setTransactionId(txid);
        connection.send(m3);
        m = this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000);
        m.setTransactionId(txid);
        connection.send(m);
        Thread.sleep(1500L);
        connection.send(this.createCommitTransaction1Phase(connectionInfo, txid));
        m = this.receiveMessage(connection);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m1.getMessageId(), (Object)m.getMessageId());
        connection.send(this.createAck(consumerInfo, m, 1, (byte)2));
        m = this.receiveMessage(connection);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m3.getMessageId(), (Object)m.getMessageId());
        connection.send(this.createAck(consumerInfo, m, 1, (byte)2));
        this.assertNoMessagesLeft(connection);
        connection.send(this.closeConnectionInfo(connectionInfo));
    }

    public void xinitCombosForTestMessagesInSubscriptionPendingListExpire() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void initCombosForTestMessagesInSubscriptionPendingListExpire() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testMessagesInSubscriptionPendingListExpire() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        consumerInfo.setPrefetchSize(1);
        connection.send(consumerInfo);
        Message m1 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        connection.send(m1);
        connection.send(this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000));
        Message m3 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        connection.send(m3);
        connection.send(this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000));
        Message m = this.receiveMessage(connection);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m1.getMessageId(), (Object)m.getMessageId());
        this.assertNoMessagesLeft(connection);
        Thread.sleep(1500L);
        connection.send(this.createAck(consumerInfo, m, 1, (byte)2));
        m = this.receiveMessage(connection);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m3.getMessageId(), (Object)m.getMessageId());
        connection.send(this.createAck(consumerInfo, m, 1, (byte)2));
        this.assertNoMessagesLeft(connection);
        connection.send(this.closeConnectionInfo(connectionInfo));
    }

    public static Test suite() {
        return MessageExpirationTest.suite(MessageExpirationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MessageExpirationTest.suite());
    }
}

