/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenTypeSupport {
    private static final Map<Class, MessageOpenTypeFactory> OPEN_TYPE_FACTORIES = new HashMap<Class, MessageOpenTypeFactory>();

    private OpenTypeSupport() {
    }

    public static OpenTypeFactory getFactory(Class<? extends Message> clazz) throws OpenDataException {
        return OPEN_TYPE_FACTORIES.get(clazz);
    }

    public static CompositeData convert(Message message) throws OpenDataException {
        OpenTypeFactory f = OpenTypeSupport.getFactory(message.getClass());
        if (f == null) {
            throw new OpenDataException("Cannot create a CompositeData for type: " + message.getClass().getName());
        }
        CompositeType ct = f.getCompositeType();
        Map<String, Object> fields = f.getFields(message);
        return new CompositeDataSupport(ct, fields);
    }

    static {
        OPEN_TYPE_FACTORIES.put(ActiveMQMessage.class, new MessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(ActiveMQBytesMessage.class, new ByteMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(ActiveMQMapMessage.class, new MapMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(ActiveMQObjectMessage.class, new ObjectMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(ActiveMQStreamMessage.class, new StreamMessageOpenTypeFactory());
        OPEN_TYPE_FACTORIES.put(ActiveMQTextMessage.class, new TextMessageOpenTypeFactory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TextMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        TextMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return ActiveMQTextMessage.class.getName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("Text", "Text", SimpleType.STRING);
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            ActiveMQTextMessage m = (ActiveMQTextMessage)o;
            Map<String, Object> rc = super.getFields(o);
            try {
                rc.put("Text", "" + m.getText());
            }
            catch (JMSException e) {
                rc.put("Text", "");
            }
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StreamMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        StreamMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return ActiveMQStreamMessage.class.getName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            Map<String, Object> rc = super.getFields(o);
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ObjectMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        ObjectMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return ActiveMQObjectMessage.class.getName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            Map<String, Object> rc = super.getFields(o);
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        MapMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return ActiveMQMapMessage.class.getName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("ContentMap", "Content map", SimpleType.STRING);
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            ActiveMQMapMessage m = (ActiveMQMapMessage)o;
            Map<String, Object> rc = super.getFields(o);
            try {
                rc.put("ContentMap", "" + m.getContentMap());
            }
            catch (JMSException e) {
                rc.put("ContentMap", "");
            }
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        ByteMessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return ActiveMQBytesMessage.class.getName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("BodyLength", "Body length", SimpleType.LONG);
            this.addItem("BodyPreview", "Body preview", new ArrayType(1, SimpleType.BYTE));
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            ActiveMQBytesMessage m = (ActiveMQBytesMessage)o;
            Map<String, Object> rc = super.getFields(o);
            long length = 0L;
            try {
                length = m.getBodyLength();
                rc.put("BodyLength", length);
            }
            catch (JMSException e) {
                rc.put("BodyLength", 0L);
            }
            try {
                byte[] preview = new byte[(int)Math.min(length, 255L)];
                m.readBytes(preview);
                Byte[] data = new Byte[preview.length];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = new Byte(preview[i]);
                }
                rc.put("BodyPreview", data);
            }
            catch (JMSException e) {
                rc.put("BodyPreview", new byte[0]);
            }
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MessageOpenTypeFactory
    extends AbstractOpenTypeFactory {
        MessageOpenTypeFactory() {
        }

        @Override
        protected String getTypeName() {
            return ActiveMQMessage.class.getName();
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("JMSCorrelationID", "JMSCorrelationID", SimpleType.STRING);
            this.addItem("JMSDestination", "JMSDestination", SimpleType.STRING);
            this.addItem("JMSMessageID", "JMSMessageID", SimpleType.STRING);
            this.addItem("JMSReplyTo", "JMSReplyTo", SimpleType.STRING);
            this.addItem("JMSType", "JMSType", SimpleType.STRING);
            this.addItem("JMSDeliveryMode", "JMSDeliveryMode", SimpleType.STRING);
            this.addItem("JMSExpiration", "JMSExpiration", SimpleType.LONG);
            this.addItem("JMSPriority", "JMSPriority", SimpleType.INTEGER);
            this.addItem("JMSRedelivered", "JMSRedelivered", SimpleType.BOOLEAN);
            this.addItem("JMSTimestamp", "JMSTimestamp", SimpleType.DATE);
            this.addItem("Properties", "Properties", SimpleType.STRING);
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            ActiveMQMessage m = (ActiveMQMessage)o;
            Map<String, Object> rc = super.getFields(o);
            rc.put("JMSCorrelationID", m.getJMSCorrelationID());
            rc.put("JMSDestination", "" + m.getJMSDestination());
            rc.put("JMSMessageID", m.getJMSMessageID());
            rc.put("JMSReplyTo", "" + m.getJMSReplyTo());
            rc.put("JMSType", m.getJMSType());
            rc.put("JMSDeliveryMode", m.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON-PERSISTENT");
            rc.put("JMSExpiration", m.getJMSExpiration());
            rc.put("JMSPriority", m.getJMSPriority());
            rc.put("JMSRedelivered", m.getJMSRedelivered());
            rc.put("JMSTimestamp", new Date(m.getJMSTimestamp()));
            try {
                rc.put("Properties", "" + m.getProperties());
            }
            catch (IOException e) {
                rc.put("Properties", "");
            }
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractOpenTypeFactory
    implements OpenTypeFactory {
        private CompositeType compositeType;
        private List<String> itemNamesList = new ArrayList<String>();
        private List<String> itemDescriptionsList = new ArrayList<String>();
        private List<OpenType> itemTypesList = new ArrayList<OpenType>();

        AbstractOpenTypeFactory() {
        }

        @Override
        public CompositeType getCompositeType() throws OpenDataException {
            if (this.compositeType == null) {
                this.init();
                this.compositeType = this.createCompositeType();
            }
            return this.compositeType;
        }

        protected void init() throws OpenDataException {
        }

        protected CompositeType createCompositeType() throws OpenDataException {
            String[] itemNames = this.itemNamesList.toArray(new String[this.itemNamesList.size()]);
            String[] itemDescriptions = this.itemDescriptionsList.toArray(new String[this.itemDescriptionsList.size()]);
            OpenType[] itemTypes = this.itemTypesList.toArray(new OpenType[this.itemTypesList.size()]);
            return new CompositeType(this.getTypeName(), this.getDescription(), itemNames, itemDescriptions, itemTypes);
        }

        protected abstract String getTypeName();

        protected void addItem(String name, String description, OpenType type) {
            this.itemNamesList.add(name);
            this.itemDescriptionsList.add(description);
            this.itemTypesList.add(type);
        }

        protected String getDescription() {
            return this.getTypeName();
        }

        @Override
        public Map<String, Object> getFields(Object o) throws OpenDataException {
            HashMap<String, Object> rc = new HashMap<String, Object>();
            return rc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface OpenTypeFactory {
        public CompositeType getCompositeType() throws OpenDataException;

        public Map<String, Object> getFields(Object var1) throws OpenDataException;
    }
}

