/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Assert;
import org.apache.camel.CamelTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CamelJmsTest
extends SpringTestSupport {
    private static final Log LOG = LogFactory.getLog(CamelJmsTest.class);
    protected String expectedBody = "<hello>world!</hello>";

    public void testSendingViaJmsIsReceivedByCamel() throws Exception {
        MockEndpoint result = (MockEndpoint)this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(new Object[]{this.expectedBody});
        result.message(0).header("foo").isEqualTo((Object)"bar");
        Destination destination = (Destination)this.getMandatoryBean(Destination.class, "sendTo");
        ConnectionFactory factory = (ConnectionFactory)this.getMandatoryBean(ConnectionFactory.class, "connectionFactory");
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(destination);
        ObjectMessage message = session.createObjectMessage((Serializable)((Object)this.expectedBody));
        message.setStringProperty("foo", "bar");
        producer.send(message);
        result.assertIsSatisfied();
        LOG.info("Received message: " + result.getReceivedExchanges());
    }

    public void testConsumingViaJMSReceivesMessageFromCamel() throws Exception {
        Destination destination = (Destination)this.getMandatoryBean(Destination.class, "consumeFrom");
        ConnectionFactory factory = (ConnectionFactory)this.getMandatoryBean(ConnectionFactory.class, "connectionFactory");
        CamelTemplate template = (CamelTemplate)this.getMandatoryBean(CamelTemplate.class, "camelTemplate");
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        LOG.info("Consuming from: " + destination);
        MessageConsumer consumer = session.createConsumer(destination);
        template.sendBody("seda:consumer", (Object)this.expectedBody);
        Message message = consumer.receive(5000L);
        Assert.assertNotNull((String)("Should have received a message from destination: " + destination), (Object)message);
        TextMessage textMessage = (TextMessage)this.assertIsInstanceOf(TextMessage.class, message);
        Assert.assertEquals((String)"Message body", (String)this.expectedBody, (String)textMessage.getText());
        LOG.info("Received message: " + message);
    }

    protected int getExpectedRouteCount() {
        return 0;
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/activemq/camel/spring.xml");
    }
}

