/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Message;
import org.apache.activemq.util.ByteSequence;

public class ActiveMQTextMessageTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(ActiveMQTextMessageTest.class);
    }

    public void testGetDataStructureType() {
        ActiveMQTextMessage msg = new ActiveMQTextMessage();
        ActiveMQTextMessageTest.assertEquals((byte)msg.getDataStructureType(), (byte)28);
    }

    public void testShallowCopy() throws JMSException {
        ActiveMQTextMessage msg = new ActiveMQTextMessage();
        String string = "str";
        msg.setText(string);
        Message copy = msg.copy();
        ActiveMQTextMessageTest.assertTrue((msg.getText() == ((ActiveMQTextMessage)copy).getText() ? 1 : 0) != 0);
    }

    public void testSetText() {
        ActiveMQTextMessage msg = new ActiveMQTextMessage();
        String str = "testText";
        try {
            msg.setText(str);
            ActiveMQTextMessageTest.assertEquals((String)msg.getText(), (String)str);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void testGetBytes() throws JMSException, IOException {
        ActiveMQTextMessage msg = new ActiveMQTextMessage();
        String str = "testText";
        msg.setText(str);
        msg.beforeMarshall(null);
        ByteSequence bytes = msg.getContent();
        msg = new ActiveMQTextMessage();
        msg.setContent(bytes);
        ActiveMQTextMessageTest.assertEquals((String)msg.getText(), (String)str);
    }

    public void testClearBody() throws JMSException, IOException {
        ActiveMQTextMessage textMessage = new ActiveMQTextMessage();
        textMessage.setText("string");
        textMessage.clearBody();
        ActiveMQTextMessageTest.assertFalse((boolean)textMessage.isReadOnlyBody());
        ActiveMQTextMessageTest.assertNull((Object)textMessage.getText());
        try {
            textMessage.setText("String");
            textMessage.getText();
        }
        catch (MessageNotWriteableException mnwe) {
            ActiveMQTextMessageTest.fail((String)"should be writeable");
        }
        catch (MessageNotReadableException mnre) {
            ActiveMQTextMessageTest.fail((String)"should be readable");
        }
    }

    public void testReadOnlyBody() throws JMSException {
        ActiveMQTextMessage textMessage = new ActiveMQTextMessage();
        textMessage.setText("test");
        textMessage.setReadOnlyBody(true);
        try {
            textMessage.getText();
        }
        catch (MessageNotReadableException e) {
            ActiveMQTextMessageTest.fail((String)"should be readable");
        }
        try {
            textMessage.setText("test");
            ActiveMQTextMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    public void testWriteOnlyBody() throws JMSException {
        ActiveMQTextMessage textMessage = new ActiveMQTextMessage();
        textMessage.setReadOnlyBody(false);
        try {
            textMessage.setText("test");
            textMessage.getText();
        }
        catch (MessageNotReadableException e) {
            ActiveMQTextMessageTest.fail((String)"should be readable");
        }
        textMessage.setReadOnlyBody(true);
        try {
            textMessage.getText();
            textMessage.setText("test");
            ActiveMQTextMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotReadableException e) {
            ActiveMQTextMessageTest.fail((String)"should be readable");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }
}

