/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.NetworkConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractApplicationContext;

public class NetworkConnectionsCleanedupTest
extends TestCase {
    protected static final int MESSAGE_COUNT = 10;
    private static final Log LOG = LogFactory.getLog(NetworkConnectionsCleanedupTest.class);
    protected AbstractApplicationContext context;
    protected Connection localConnection;
    protected Connection remoteConnection;
    protected BrokerService localBroker;
    protected BrokerService remoteBroker;
    protected Session localSession;
    protected Session remoteSession;
    protected ActiveMQTopic included;
    protected ActiveMQTopic excluded;
    protected String consumerName = "durableSubs";

    public void testNetworkConnections() throws Exception {
        String uri = "static:(tcp://localhost:61617)?initialReconnectDelay=100";
        ArrayList<ActiveMQDestination> list = new ArrayList<ActiveMQDestination>();
        for (int i = 0; i < 100; ++i) {
            list.add(new ActiveMQTopic("FOO" + i));
        }
        String bindAddress = "tcp://localhost:61616";
        BrokerService broker = new BrokerService();
        broker.setUseJmx(false);
        broker.setPersistent(false);
        broker.addConnector(bindAddress);
        NetworkConnector network = broker.addNetworkConnector(uri);
        network.setDynamicOnly(true);
        network.setStaticallyIncludedDestinations(list);
        uri = "static:(tcp://localhost:61618)?initialReconnectDelay=100";
        network = broker.addNetworkConnector(uri);
        network.setDynamicOnly(true);
        network.setStaticallyIncludedDestinations(list);
        broker.setUseShutdownHook(false);
        broker.start();
        Thread.sleep(3600000L);
    }
}

