/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.ArrayList;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.AuthorizationEntry;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.DefaultAuthorizationMap;
import org.apache.activemq.security.TempDestinationAuthorizationEntry;

public class AuthorizationMapTest
extends TestCase {
    static final GroupPrincipal GUESTS = new GroupPrincipal("guests");
    static final GroupPrincipal USERS = new GroupPrincipal("users");
    static final GroupPrincipal ADMINS = new GroupPrincipal("admins");
    static final GroupPrincipal TEMP_DESTINATION_ADMINS = new GroupPrincipal("tempDestAdmins");

    public void testAuthorizationMap() {
        AuthorizationMap map = this.createAuthorizationMap();
        Set<?> readACLs = map.getReadACLs(new ActiveMQQueue("USERS.FOO.BAR"));
        AuthorizationMapTest.assertEquals((String)("set size: " + readACLs), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(ADMINS));
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
    }

    public void testAuthorizationMapWithTempDest() {
        AuthorizationMap map = this.createAuthorizationMapWithTempDest();
        Set<?> readACLs = map.getReadACLs(new ActiveMQQueue("USERS.FOO.BAR"));
        AuthorizationMapTest.assertEquals((String)("set size: " + readACLs), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(ADMINS));
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        Set<?> tempAdminACLs = map.getTempDestinationAdminACLs();
        AuthorizationMapTest.assertEquals((String)("set size: " + tempAdminACLs), (int)1, (int)tempAdminACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)tempAdminACLs.contains(TEMP_DESTINATION_ADMINS));
    }

    protected AuthorizationMap createAuthorizationMap() {
        DefaultAuthorizationMap answer = new DefaultAuthorizationMap();
        ArrayList<AuthorizationEntry> entries = new ArrayList<AuthorizationEntry>();
        AuthorizationEntry entry = new AuthorizationEntry();
        entry.setGroupClass("org.apache.activemq.jaas.GroupPrincipal");
        entry.setQueue(">");
        try {
            entry.setRead("admins");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        entries.add(entry);
        entry = new AuthorizationEntry();
        entry.setQueue("USERS.>");
        try {
            entry.setRead("users");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        entries.add(entry);
        answer.setAuthorizationEntries(entries);
        return answer;
    }

    protected AuthorizationMap createAuthorizationMapWithTempDest() {
        DefaultAuthorizationMap answer = new DefaultAuthorizationMap();
        ArrayList<AuthorizationEntry> entries = new ArrayList<AuthorizationEntry>();
        AuthorizationEntry entry = new AuthorizationEntry();
        entry.setQueue(">");
        try {
            entry.setRead("admins");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        entries.add(entry);
        entry = new AuthorizationEntry();
        entry.setQueue("USERS.>");
        try {
            entry.setRead("users");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        entries.add(entry);
        answer.setAuthorizationEntries(entries);
        TempDestinationAuthorizationEntry tEntry = new TempDestinationAuthorizationEntry();
        try {
            tEntry.setAdmin("tempDestAdmins");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        answer.setTempDestinationAuthorizationEntry(tEntry);
        return answer;
    }
}

