/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.transport.stomp.SamplePojo;
import org.apache.activemq.transport.stomp.Stomp;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StompTest
extends CombinationTestSupport {
    private static final Log LOG = LogFactory.getLog(StompTest.class);
    protected String bindAddress = "stomp://localhost:61613";
    protected String confUri = "xbean:org/apache/activemq/transport/stomp/stomp-auth-broker.xml";
    private BrokerService broker;
    private StompConnection stompConnection = new StompConnection();
    private Connection connection;
    private Session session;
    private ActiveMQQueue queue;
    private String xmlObject = "<pojo>\n  <name>Dejan</name>\n  <city>Belgrade</city>\n</pojo>";
    private String xmlMap = "<map>\n  <entry>\n    <string>name</string>\n    <string>Dejan</string>\n  </entry>\n  <entry>\n    <string>city</string>\n    <string>Belgrade</string>\n  </entry>\n</map>\n";
    private String jsonObject = "{\"pojo\":{\"name\":\"Dejan\",\"city\":\"Belgrade\"}}";
    private String jsonMap = "{\"map\":{\"entry\":[{\"string\":[\"name\",\"Dejan\"]},{\"string\":[\"city\",\"Belgrade\"]}]}}";

    protected void setUp() throws Exception {
        this.broker = BrokerFactory.createBroker(new URI(this.confUri));
        this.broker.start();
        this.stompConnect();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        this.connection = cf.createConnection("system", "manager");
        this.session = this.connection.createSession(false, 1);
        this.queue = new ActiveMQQueue(this.getQueueName());
        this.connection.start();
    }

    private void stompConnect() throws IOException, URISyntaxException, UnknownHostException {
        URI connectUri = new URI(this.bindAddress);
        this.stompConnection.open(this.createSocket(connectUri));
    }

    protected Socket createSocket(URI connectUri) throws IOException {
        return new Socket("127.0.0.1", connectUri.getPort());
    }

    protected String getQueueName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
        this.stompDisconnect();
        this.broker.stop();
    }

    private void stompDisconnect() throws IOException {
        if (this.stompConnection != null) {
            this.stompConnection.close();
            this.stompConnection = null;
        }
    }

    public void sendMessage(String msg) throws Exception {
        this.sendMessage(msg, "foo", "xyz");
    }

    public void sendMessage(String msg, String propertyName, String propertyValue) throws JMSException {
        MessageProducer producer = this.session.createProducer(this.queue);
        TextMessage message = this.session.createTextMessage(msg);
        message.setStringProperty(propertyName, propertyValue);
        producer.send(message);
    }

    public void sendBytesMessage(byte[] msg) throws Exception {
        MessageProducer producer = this.session.createProducer(this.queue);
        BytesMessage message = this.session.createBytesMessage();
        message.writeBytes(msg);
        producer.send(message);
    }

    public void testConnect() throws Exception {
        String connectFrame = "CONNECT\nlogin: system\npasscode: manager\nrequest-id: 1\n\n\u0000";
        this.stompConnection.sendFrame(connectFrame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("CONNECTED"));
        StompTest.assertTrue((f.indexOf("response-id:1") >= 0 ? 1 : 0) != 0);
    }

    public void testSendMessage() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"Hello World", (String)message.getText());
        long tnow = System.currentTimeMillis();
        long tmsg = message.getJMSTimestamp();
        StompTest.assertTrue((Math.abs(tnow - tmsg) < 1000L ? 1 : 0) != 0);
    }

    public void testJMSXGroupIdCanBeSet() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "JMSXGroupID: TEST\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"TEST", (String)((ActiveMQTextMessage)message).getGroupID());
    }

    public void testSendMessageWithCustomHeadersAndSelector() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue, "foo = 'abc'");
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\nfoo:abc\nbar:123\ndestination:/queue/" + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"Hello World", (String)message.getText());
        StompTest.assertEquals((String)"foo", (String)"abc", (String)message.getStringProperty("foo"));
        StompTest.assertEquals((String)"bar", (String)"123", (String)message.getStringProperty("bar"));
    }

    public void testSendMessageWithStandardHeaders() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ncorrelation-id:c123\npriority:3\ntype:t345\nJMSXGroupID:abc\nfoo:abc\nbar:123\ndestination:/queue/" + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"Hello World", (String)message.getText());
        StompTest.assertEquals((String)"JMSCorrelationID", (String)"c123", (String)message.getJMSCorrelationID());
        StompTest.assertEquals((String)"getJMSType", (String)"t345", (String)message.getJMSType());
        StompTest.assertEquals((String)"getJMSPriority", (int)3, (int)message.getJMSPriority());
        StompTest.assertEquals((String)"foo", (String)"abc", (String)message.getStringProperty("foo"));
        StompTest.assertEquals((String)"bar", (String)"123", (String)message.getStringProperty("bar"));
        StompTest.assertEquals((String)"JMSXGroupID", (String)"abc", (String)message.getStringProperty("JMSXGroupID"));
        ActiveMQTextMessage amqMessage = (ActiveMQTextMessage)message;
        StompTest.assertEquals((String)"GroupID", (String)"abc", (String)amqMessage.getGroupID());
    }

    public void testSubscribeWithAutoAck() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.sendMessage(this.getName());
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testSubscribeWithAutoAckAndBytesMessage() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.sendBytesMessage(new byte[]{1, 2, 3, 4, 5});
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        Pattern cl = Pattern.compile("Content-length:\\s*(\\d+)", 2);
        Matcher clMmatcher = cl.matcher(frame);
        StompTest.assertTrue((boolean)clMmatcher.find());
        StompTest.assertEquals((String)"5", (String)clMmatcher.group(1));
        StompTest.assertFalse((boolean)Pattern.compile("type:\\s*null", 2).matcher(frame).find());
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testSubscribeWithMessageSentWithProperties() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        MessageProducer producer = this.session.createProducer(this.queue);
        TextMessage message = this.session.createTextMessage("Hello World");
        message.setStringProperty("s", "value");
        message.setBooleanProperty("n", false);
        message.setByteProperty("byte", (byte)9);
        message.setDoubleProperty("d", 2.0);
        message.setFloatProperty("f", 6.0f);
        message.setIntProperty("i", 10);
        message.setLongProperty("l", 121L);
        message.setShortProperty("s", (short)12);
        producer.send(message);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testMessagesAreInOrder() throws Exception {
        int i;
        int ctr = 10;
        String[] data = new String[ctr];
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        for (i = 0; i < ctr; ++i) {
            data[i] = this.getName() + i;
            this.sendMessage(data[i]);
        }
        for (i = 0; i < ctr; ++i) {
            frame = this.stompConnection.receiveFrame();
            StompTest.assertTrue((String)"Message not in order", (frame.indexOf(data[i]) >= 0 ? 1 : 0) != 0);
        }
        this.waitForFrameToTakeEffect();
        for (i = 0; i < ctr; ++i) {
            data[i] = this.getName() + ":second:" + i;
            this.sendMessage(data[i]);
        }
        for (i = 0; i < ctr; ++i) {
            frame = this.stompConnection.receiveFrame();
            StompTest.assertTrue((String)"Message not in order", (frame.indexOf(data[i]) >= 0 ? 1 : 0) != 0);
        }
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testSubscribeWithAutoAckAndSelector() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "selector: foo = 'zzz'\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.sendMessage("Ignored message", "foo", "1234");
        this.sendMessage("Real message", "foo", "zzz");
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        StompTest.assertTrue((String)("Should have received the real message but got: " + frame), (frame.indexOf("Real message") > 0 ? 1 : 0) != 0);
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testSubscribeWithClientAck() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:client\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.sendMessage(this.getName());
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        this.stompDisconnect();
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertTrue((boolean)message.getJMSRedelivered());
    }

    public void testUnsubscribe() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.sendMessage("first message");
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("MESSAGE"));
        frame = "UNSUBSCRIBE\ndestination:/queue/" + this.getQueueName() + "\n" + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        this.waitForFrameToTakeEffect();
        this.sendMessage("second message");
        try {
            frame = this.stompConnection.receiveFrame();
            LOG.info("Received frame: " + frame);
            StompTest.fail((String)"No message should have been received since subscription was removed");
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
    }

    public void testTransactionCommit() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("CONNECTED"));
        frame = "BEGIN\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transaction: tx1\n" + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "COMMIT\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        this.waitForFrameToTakeEffect();
        TextMessage message = (TextMessage)consumer.receive(1000L);
        StompTest.assertNotNull((String)"Should have received a message", (Object)message);
    }

    public void testTransactionRollback() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("CONNECTED"));
        frame = "BEGIN\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transaction: tx1\n" + "\n" + "first message" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "ABORT\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "BEGIN\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transaction: tx1\n" + "\n" + "second message" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = "COMMIT\ntransaction: tx1\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        this.waitForFrameToTakeEffect();
        TextMessage message = (TextMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"second message", (String)message.getText().trim());
    }

    public void testDisconnectedClientsAreRemovedFromTheBroker() throws Exception {
        this.assertClients(1);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        this.waitForFrameToTakeEffect();
        this.assertClients(2);
        this.stompConnection.close();
        Thread.sleep(2000L);
        this.assertClients(1);
    }

    public void testConnectNotAuthenticatedWrongUser() throws Exception {
        String frame = "CONNECT\nlogin: dejanb\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("ERROR"));
        this.assertClients(1);
    }

    public void testConnectNotAuthenticatedWrongPassword() throws Exception {
        String frame = "CONNECT\nlogin: system\npasscode: dejanb\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("ERROR"));
        this.assertClients(1);
    }

    public void testSendNotAuthorized() throws Exception {
        String frame = "CONNECT\nlogin: guest\npasscode: password\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/USERS." + this.getQueueName() + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("ERROR"));
    }

    public void testSubscribeNotAuthorized() throws Exception {
        String frame = "CONNECT\nlogin: guest\npasscode: password\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        String f = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)f.startsWith("ERROR"));
    }

    public void testTransformationUnknownTranslator() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:test" + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)"Hello World", (String)message.getText());
    }

    public void testTransformationFailed() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_OBJECT_XML) + "\n\n" + "Hello World" + "\u0000";
        this.stompConnection.sendFrame(frame);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertNotNull((Object)message.getStringProperty("transformation-error"));
        StompTest.assertEquals((String)"Hello World", (String)message.getText());
    }

    public void testTransformationSendXMLObject() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_OBJECT_XML) + "\n\n" + this.xmlObject + "\u0000";
        this.stompConnection.sendFrame(frame);
        ObjectMessage message = (ObjectMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        SamplePojo object = (SamplePojo)message.getObject();
        StompTest.assertEquals((String)"Dejan", (String)object.getName());
    }

    public void testTransformationSendJSONObject() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_OBJECT_JSON) + "\n\n" + this.jsonObject + "\u0000";
        this.stompConnection.sendFrame(frame);
        ObjectMessage message = (ObjectMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        SamplePojo object = (SamplePojo)message.getObject();
        StompTest.assertEquals((String)"Dejan", (String)object.getName());
    }

    public void testTransformationSubscribeXML() throws Exception {
        MessageProducer producer = this.session.createProducer(new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage(new SamplePojo("Dejan", "Belgrade"));
        producer.send(message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_OBJECT_XML) + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.xmlObject));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationReceiveJSONObject() throws Exception {
        MessageProducer producer = this.session.createProducer(new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage(new SamplePojo("Dejan", "Belgrade"));
        producer.send(message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_OBJECT_JSON) + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.jsonObject));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationReceiveXMLObject() throws Exception {
        MessageProducer producer = this.session.createProducer(new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage(new SamplePojo("Dejan", "Belgrade"));
        producer.send(message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_OBJECT_XML) + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.xmlObject));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationNotOverrideSubscription() throws Exception {
        MessageProducer producer = this.session.createProducer(new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage(new SamplePojo("Dejan", "Belgrade"));
        message.setStringProperty("transformation", Stomp.Transformations.JMS_OBJECT_XML.toString());
        producer.send(message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_OBJECT_JSON) + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.jsonObject));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationIgnoreTransformation() throws Exception {
        MessageProducer producer = this.session.createProducer(new ActiveMQQueue("USERS." + this.getQueueName()));
        ObjectMessage message = this.session.createObjectMessage(new SamplePojo("Dejan", "Belgrade"));
        message.setStringProperty("transformation", Stomp.Transformations.JMS_OBJECT_XML.toString());
        producer.send(message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto" + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.endsWith("\n\n"));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationSendXMLMap() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_MAP_XML) + "\n\n" + this.xmlMap + "\u0000";
        this.stompConnection.sendFrame(frame);
        MapMessage message = (MapMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)message.getString("name"), (String)"Dejan");
    }

    public void testTransformationSendJSONMap() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.queue);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SEND\ndestination:/queue/" + this.getQueueName() + "\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_MAP_JSON) + "\n\n" + this.jsonMap + "\u0000";
        this.stompConnection.sendFrame(frame);
        MapMessage message = (MapMessage)consumer.receive(1000L);
        StompTest.assertNotNull((Object)message);
        StompTest.assertEquals((String)message.getString("name"), (String)"Dejan");
    }

    public void testTransformationReceiveXMLMap() throws Exception {
        MessageProducer producer = this.session.createProducer(new ActiveMQQueue("USERS." + this.getQueueName()));
        MapMessage message = this.session.createMapMessage();
        message.setString("name", "Dejan");
        message.setString("city", "Belgrade");
        producer.send(message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_MAP_XML) + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.xmlMap.trim()));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    public void testTransformationReceiveJSONMap() throws Exception {
        MessageProducer producer = this.session.createProducer(new ActiveMQQueue("USERS." + this.getQueueName()));
        MapMessage message = this.session.createMapMessage();
        message.setString("name", "Dejan");
        message.setString("city", "Belgrade");
        producer.send(message);
        String frame = "CONNECT\nlogin: system\npasscode: manager\n\n\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/queue/USERS." + this.getQueueName() + "\n" + "ack:auto\n" + "transformation:" + (Object)((Object)Stomp.Transformations.JMS_MAP_JSON) + "\n\n" + "\u0000";
        this.stompConnection.sendFrame(frame);
        frame = this.stompConnection.receiveFrame();
        StompTest.assertTrue((boolean)frame.trim().endsWith(this.jsonMap.trim()));
        frame = "DISCONNECT\n\n\n\u0000";
        this.stompConnection.sendFrame(frame);
    }

    protected void assertClients(int expected) throws Exception {
        org.apache.activemq.broker.Connection[] clients = this.broker.getBroker().getClients();
        int actual = clients.length;
        StompTest.assertEquals((String)"Number of clients", (int)expected, (int)actual);
    }

    protected void waitForFrameToTakeEffect() throws InterruptedException {
        Thread.sleep(2000L);
    }
}

