/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.management.remote.JMXPrincipal;
import javax.net.ssl.SSLSocket;
import junit.framework.TestCase;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.transport.StubTransportListener;
import org.apache.activemq.transport.tcp.SslTransport;
import org.apache.activemq.transport.tcp.StubSSLSession;
import org.apache.activemq.transport.tcp.StubSSLSocket;
import org.apache.activemq.transport.tcp.StubX509Certificate;
import org.apache.activemq.wireformat.ObjectStreamWireFormat;
import org.apache.activemq.wireformat.WireFormat;

public class SslTransportTest
extends TestCase {
    SSLSocket sslSocket;
    StubTransportListener stubListener;
    String username;
    String password;
    String certDistinguishedName;

    protected void setUp() throws Exception {
        this.certDistinguishedName = "ThisNameIsDistinguished";
        this.username = "SomeUserName";
        this.password = "SomePassword";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void createTransportAndConsume(boolean wantAuth, boolean needAuth) throws IOException {
        JMXPrincipal principal = new JMXPrincipal(this.certDistinguishedName);
        StubX509Certificate cert = new StubX509Certificate(principal);
        StubSSLSession sslSession = new StubSSLSession(cert);
        this.sslSocket = new StubSSLSocket(sslSession);
        this.sslSocket.setWantClientAuth(wantAuth);
        this.sslSocket.setNeedClientAuth(needAuth);
        SslTransport transport = new SslTransport((WireFormat)new ObjectStreamWireFormat(), this.sslSocket);
        this.stubListener = new StubTransportListener();
        transport.setTransportListener(this.stubListener);
        ConnectionInfo sentInfo = new ConnectionInfo();
        sentInfo.setUserName(this.username);
        sentInfo.setPassword(this.password);
        transport.doConsume(sentInfo);
    }

    public void testKeepClientUserName() throws IOException {
        X509Certificate receivedCert;
        this.createTransportAndConsume(true, true);
        ConnectionInfo receivedInfo = (ConnectionInfo)this.stubListener.getCommands().remove();
        try {
            receivedCert = ((X509Certificate[])receivedInfo.getTransportContext())[0];
        }
        catch (Exception e) {
            receivedCert = null;
        }
        if (receivedCert == null) {
            SslTransportTest.fail((String)"Transmitted certificate chain was not attached to ConnectionInfo.");
        }
        SslTransportTest.assertEquals((String)"Received certificate distinguished name did not match the one transmitted.", (String)this.certDistinguishedName, (String)receivedCert.getSubjectDN().getName());
    }
}

